/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.verifier.builder.BaseClassProvider;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ClassMetaData;
import org.springframework.cloud.contract.verifier.builder.DefaultClassMetadata;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.util.StringUtils;

class GroovyClassMetaData
implements ClassMetaData,
DefaultClassMetadata {
    private final BlockBuilder blockBuilder;
    private final BaseClassProvider baseClassProvider = new BaseClassProvider();
    private final GeneratedClassMetaData generatedClassMetaData;

    GroovyClassMetaData(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public ClassMetaData setupLineEnding() {
        return this;
    }

    @Override
    public ClassMetaData setupLabelPrefix() {
        return this;
    }

    @Override
    public ClassMetaData suffix() {
        String suffix;
        String string = suffix = StringUtils.hasText((String)this.generatedClassMetaData.configProperties.getNameSuffixForTests()) ? this.generatedClassMetaData.configProperties.getNameSuffixForTests() : "Spec";
        if (!this.blockBuilder.endsWith(suffix)) {
            this.blockBuilder.addAtTheEnd(suffix);
        }
        return this;
    }

    @Override
    public ClassMetaData modifier() {
        return this;
    }

    @Override
    public ClassMetaData packageDefinition() {
        this.blockBuilder.addLineWithEnding("package " + this.generatedClassMetaData.generatedClassData.classPackage);
        return this;
    }

    @Override
    public ClassMetaData parentClass() {
        ContractVerifierConfigProperties properties = this.generatedClassMetaData().configProperties;
        String includedDirectoryRelativePath = this.generatedClassMetaData().includedDirectoryRelativePath;
        String baseClass = this.baseClassProvider().retrieveBaseClass(properties.getBaseClassMappings(), properties.getPackageWithBaseClasses(), properties.getBaseClassForTests(), includedDirectoryRelativePath);
        baseClass = StringUtils.hasText((String)baseClass) ? baseClass : "Specification";
        int lastIndexOf = baseClass.lastIndexOf(".");
        if (lastIndexOf > 0) {
            baseClass = baseClass.substring(lastIndexOf + 1);
        }
        this.blockBuilder().append("extends ").append(baseClass).append(" ");
        return this;
    }

    @Override
    public GeneratedClassMetaData generatedClassMetaData() {
        return this.generatedClassMetaData;
    }

    @Override
    public BaseClassProvider baseClassProvider() {
        return this.baseClassProvider;
    }

    @Override
    public BlockBuilder blockBuilder() {
        return this.blockBuilder;
    }

    @Override
    public boolean accept() {
        return this.generatedClassMetaData.configProperties.getTestFramework() == TestFramework.SPOCK;
    }
}

