/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.Imports;
import org.springframework.cloud.contract.verifier.config.TestFramework;

class SpockIgnoreImports
implements Imports {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;

    SpockIgnoreImports(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public Imports call() {
        this.blockBuilder.addLineWithEnding("import spock.lang.Ignore");
        return this;
    }

    @Override
    public boolean accept() {
        return this.generatedClassMetaData.configProperties.getTestFramework() == TestFramework.SPOCK && this.generatedClassMetaData.listOfFiles.stream().anyMatch(metadata -> metadata.isIgnored() || metadata.getConvertedContractWithMetadata().stream().anyMatch(m -> m.isIgnored() || m.isInProgress()));
    }
}

