/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;

public final class NamesUtil {
    private NamesUtil() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static String beforeLast(String string, String separator) {
        if (string != null && string.indexOf(separator) > -1) {
            return string.substring(0, string.lastIndexOf(separator));
        }
        return "";
    }

    public static String afterLast(String string, String separator) {
        if (NamesUtil.hasSeparator(string, separator)) {
            return string.substring(string.lastIndexOf(separator) + 1);
        }
        return string;
    }

    public static boolean hasSeparator(String string, String separator) {
        return string.indexOf(separator) > -1;
    }

    public static String afterLastDot(String string) {
        return NamesUtil.afterLast(string, ".");
    }

    public static boolean hasDot(String string) {
        return NamesUtil.hasSeparator(string, ".");
    }

    public static String defaultContractName(File file, Collection contracts, int counter) {
        int lastIndexOfDot = file.getName().lastIndexOf(".");
        String tillExtension = file.getName().substring(0, lastIndexOfDot);
        return tillExtension + (counter > 0 || contracts.size() > 1 ? "_" + counter : "");
    }

    public static String camelCase(String className) {
        if (NamesUtil.isEmpty(className)) {
            return className;
        }
        String firstChar = className.substring(0, 1).toLowerCase();
        return firstChar + className.substring(1);
    }

    public static String capitalize(String className) {
        if (NamesUtil.isEmpty(className)) {
            return className;
        }
        String firstChar = className.substring(0, 1).toUpperCase();
        return firstChar + className.substring(1);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String toLastDot(String string) {
        if (string.indexOf(".") > -1) {
            return string.substring(0, string.lastIndexOf("."));
        }
        return string;
    }

    public static String packageToDirectory(String packageName) {
        return packageName.replace('.', File.separatorChar);
    }

    public static String directoryToPackage(String directory) {
        return directory.replace('.', '_').replace(File.separatorChar, '.').replaceAll("\\.([0-9])", "._$1").replaceAll("^([0-9].*)", "_$1");
    }

    public static void recrusiveDirectoryToPackage(File rootDir) {
        try {
            if (!rootDir.exists()) {
                return;
            }
            InvalidFolderRenamer renamer = new InvalidFolderRenamer();
            Files.walkFileTree(rootDir.toPath(), renamer);
            renamer.rename();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static String convertIllegalPackageChars(String packageName) {
        return packageName.replaceAll("[_\\- .+]", "_");
    }

    public static String convertIllegalMethodNameChars(String methodName) {
        String result = methodName.replaceAll("^[^a-zA-Z_$0-9]", "_");
        return result.replaceAll("[^a-zA-Z_$0-9]", "_");
    }

    private static class InvalidFolderRenamer
    extends SimpleFileVisitor<Path> {
        private final Deque<FileAndNewName> filesToRename = new ArrayDeque<FileAndNewName>();

        private InvalidFolderRenamer() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            String convertedName;
            String name = dir.toFile().getName();
            if (!name.equals(convertedName = NamesUtil.directoryToPackage(name))) {
                this.filesToRename.addFirst(new FileAndNewName(dir.toFile(), convertedName));
            }
            return FileVisitResult.CONTINUE;
        }

        public void rename() {
            this.filesToRename.forEach(fileAndNewName -> ((FileAndNewName)fileAndNewName).file.renameTo(new File(((FileAndNewName)fileAndNewName).file.getParentFile(), ((FileAndNewName)fileAndNewName).newName)));
        }
    }

    private static final class FileAndNewName {
        private final File file;
        private final String newName;

        private FileAndNewName(File file, String newName) {
            this.file = file;
            this.newName = newName;
        }
    }
}

