/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.contract.spec.ContractVerifierException;
import org.springframework.cloud.contract.verifier.FileSaver;
import org.springframework.cloud.contract.verifier.builder.JavaTestGenerator;
import org.springframework.cloud.contract.verifier.builder.SingleTestGenerator;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.file.ContractFileScanner;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.MultiValueMap;

public class TestGenerator {
    private static final Logger log = LoggerFactory.getLogger(TestGenerator.class);
    private static final String DEFAULT_CLASS_PREFIX = "ContractVerifier";
    private static final String DEFAULT_TEST_PACKAGE = "org.springframework.cloud.contract.verifier.tests";
    private final ContractVerifierConfigProperties configProperties;
    private final AtomicInteger counter = new AtomicInteger();
    private final SingleTestGenerator generator;
    private final FileSaver saver;
    private final ContractFileScanner contractFileScanner;

    public TestGenerator(ContractVerifierConfigProperties configProperties) {
        this(configProperties, TestGenerator.singleTestGenerator(), new FileSaver(configProperties.getGeneratedTestSourcesDir(), configProperties.getTestFramework().getClassExtension()));
    }

    private static SingleTestGenerator singleTestGenerator() {
        List factories = SpringFactoriesLoader.loadFactories(SingleTestGenerator.class, null);
        if (factories.isEmpty()) {
            return new JavaTestGenerator();
        }
        return (SingleTestGenerator)factories.get(0);
    }

    public TestGenerator(ContractVerifierConfigProperties configProperties, SingleTestGenerator generator, FileSaver saver) {
        this(configProperties, generator, saver, ContractFileScanner.builder().baseDir(configProperties.getContractsDslDir()).excluded(TestGenerator.toSet(configProperties.getExcludedFiles())).ignored(TestGenerator.toSet(configProperties.getIgnoredFiles())).included(TestGenerator.toSet(configProperties.getIncludedFiles())).includeMatcher(configProperties.getIncludedContracts()).build());
    }

    private static Set<String> toSet(List<String> files) {
        return Optional.ofNullable(files).map(HashSet::new).orElseGet(HashSet::new);
    }

    protected TestGenerator(ContractVerifierConfigProperties configProperties, SingleTestGenerator generator, FileSaver saver, ContractFileScanner contractFileScanner) {
        this.configProperties = configProperties;
        if (configProperties.getContractsDslDir() == null) {
            throw new ContractVerifierException("Stubs directory not found under " + configProperties.getContractsDslDir());
        }
        this.generator = generator;
        this.saver = saver;
        this.contractFileScanner = contractFileScanner;
    }

    public int generate() {
        this.generateTestClasses(this.basePackageName());
        NamesUtil.recrusiveDirectoryToPackage(this.configProperties.getGeneratedTestSourcesDir());
        NamesUtil.recrusiveDirectoryToPackage(this.configProperties.getGeneratedTestResourcesDir());
        return this.counter.get();
    }

    private String basePackageName() {
        if (StringUtils.isNotEmpty((CharSequence)this.configProperties.getBasePackageForTests())) {
            return this.configProperties.getBasePackageForTests();
        }
        if (StringUtils.isNotEmpty((CharSequence)this.configProperties.getBaseClassForTests())) {
            return NamesUtil.toLastDot(this.configProperties.getBaseClassForTests());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.configProperties.getPackageWithBaseClasses())) {
            return this.configProperties.getPackageWithBaseClasses();
        }
        return DEFAULT_TEST_PACKAGE;
    }

    void generateTestClasses(String basePackageName) {
        MultiValueMap<Path, ContractMetadata> contracts = this.contractFileScanner.findContractsRecursively();
        log.debug("Found the following contracts {}", (Object)contracts.keySet());
        Set<Map.Entry<Path, List<ContractMetadata>>> inProgress = this.inProgress(contracts);
        if (!inProgress.isEmpty() && this.configProperties.isFailOnInProgress()) {
            String inProgressContractsPaths = inProgress.stream().map(Map.Entry::getKey).map(Path::toString).collect(Collectors.joining(","));
            throw new IllegalStateException("In progress contracts found in paths [" + inProgressContractsPaths + "] and the switch [failOnInProgress] is set to [true]. Either unmark those contracts as in progress, or set the switch to [false].");
        }
        this.processAll(contracts, basePackageName);
    }

    private Set<Map.Entry<Path, List<ContractMetadata>>> inProgress(MultiValueMap<Path, ContractMetadata> contracts) {
        return contracts.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(ContractMetadata::anyInProgress)).collect(Collectors.toSet());
    }

    void processAll(MultiValueMap<Path, ContractMetadata> contracts, String basePackageName) {
        contracts.entrySet().stream().forEach(entry -> this.processIncludedDirectory(this.relativizeContractPath((Map.Entry<Path, List<ContractMetadata>>)entry), (Collection)entry.getValue(), basePackageName));
    }

    private String relativizeContractPath(Map.Entry<Path, List<ContractMetadata>> entry) {
        Path relativePath = this.configProperties.getContractsDslDir().toPath().relativize(entry.getKey());
        return (String)StringUtils.defaultIfEmpty((CharSequence)relativePath.toString(), (CharSequence)DEFAULT_CLASS_PREFIX);
    }

    private void processIncludedDirectory(String includedDirectoryRelativePath, Collection<ContractMetadata> contracts, String basePackageNameForClass) {
        log.debug("Collected contracts with metadata {} relative path is [{}]", contracts, (Object)includedDirectoryRelativePath);
        if (!contracts.isEmpty()) {
            String className = NamesUtil.afterLast(includedDirectoryRelativePath, File.separator) + this.resolveNameSuffix();
            String convertedClassName = this.ensureNameDoesNotStartWithNumber(NamesUtil.convertIllegalPackageChars(className));
            String packageName = TestGenerator.buildPackage(basePackageNameForClass, includedDirectoryRelativePath);
            Path dir = this.saver.generateTestBaseDir(basePackageNameForClass, NamesUtil.convertIllegalPackageChars(includedDirectoryRelativePath));
            Path classPath = this.saver.pathToClass(dir, convertedClassName);
            byte[] classBytes = this.generator.buildClass(this.configProperties, contracts, includedDirectoryRelativePath, new SingleTestGenerator.GeneratedClassData(convertedClassName, packageName, classPath)).getBytes(StandardCharsets.UTF_8);
            this.saver.saveClassFile(classPath, classBytes);
            this.counter.incrementAndGet();
        }
    }

    private String ensureNameDoesNotStartWithNumber(String convertedClassName) {
        return convertedClassName.matches("[0-9]+.*") ? "_" + convertedClassName : convertedClassName;
    }

    private String resolveNameSuffix() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.configProperties.getNameSuffixForTests(), (CharSequence)this.configProperties.getTestFramework().getClassNameSuffix());
    }

    protected static String buildPackage(String packageNameForClass, String includedDirectoryRelativePath) {
        String directory = NamesUtil.beforeLast(includedDirectoryRelativePath, File.separator);
        String convertedPackage = packageNameForClass + "." + NamesUtil.directoryToPackage(NamesUtil.convertIllegalPackageChars(directory));
        return !directory.isEmpty() ? convertedPackage : packageNameForClass;
    }
}

