/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.messaging.stream.DefaultChannels;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

class DestinationResolver {
    private static final Log log = LogFactory.getLog(DestinationResolver.class);
    private final ApplicationContext context;

    DestinationResolver(ApplicationContext context) {
        this.context = context;
    }

    String resolvedDestination(String destination, DefaultChannels defaultChannel) {
        try {
            BindingServiceProperties channelBindingServiceProperties = (BindingServiceProperties)this.context.getBean(BindingServiceProperties.class);
            HashMap<String, String> channels = new HashMap<String, String>();
            for (Map.Entry entry : channelBindingServiceProperties.getBindings().entrySet()) {
                if (!destination.equals(((BindingProperties)entry.getValue()).getDestination())) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found a channel named [" + (String)entry.getKey() + "] with destination [" + destination + "]"));
                }
                channels.put((String)entry.getKey(), destination);
            }
            if (channels.size() == 1) {
                return (String)channels.keySet().iterator().next();
            }
            if (channels.size() > 0) {
                String defaultChannelName;
                String matchingChannelName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found following channels [" + channels + "] for destination [" + destination + "]. Will pick the one that matches the default channel name or the first one if none is matching"));
                }
                String string = matchingChannelName = StringUtils.hasText((String)(defaultChannelName = (String)channels.get(defaultChannel.name().toLowerCase()))) ? defaultChannel.name().toLowerCase() : (String)channels.keySet().iterator().next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Picked channel name is [" + matchingChannelName + "]"));
                }
                return matchingChannelName;
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception took place while trying to resolve the destination. Will assume the name [" + destination + "]"), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No destination named [" + destination + "] was found. Assuming that the destination equals the channel name"));
        }
        return destination;
    }
}

