/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.FaultInjector;
import com.github.tomakehurst.wiremock.jetty9.JettyUtils;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;

public class JettyFaultInjector
implements FaultInjector {
    private static final byte[] GARBAGE = "lskdu018973t09sylgasjkfg1][]'./.sdlv".getBytes(Charset.forName("UTF-8"));
    private final Response response;
    private final ByteChannel socket;

    public JettyFaultInjector(HttpServletResponse response) {
        this.response = JettyUtils.unwrapResponse((HttpServletResponse)response);
        this.socket = this.socket();
    }

    public void emptyResponseAndCloseConnection() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked((Throwable)e);
        }
    }

    public void malformedResponseChunk() {
        try {
            this.response.setStatus(200);
            this.response.flushBuffer();
            this.socket.write(BufferUtil.toBuffer((byte[])GARBAGE));
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked((Throwable)e);
        }
    }

    public void randomDataAndCloseConnection() {
        try {
            this.socket.write(BufferUtil.toBuffer((byte[])GARBAGE));
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked((Throwable)e);
        }
    }

    private ByteChannel socket() {
        HttpChannel httpChannel = this.response.getHttpOutput().getHttpChannel();
        ChannelEndPoint ep = (ChannelEndPoint)httpChannel.getEndPoint();
        return ep.getChannel();
    }
}

