/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.FaultInjector;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletResponse;
import org.apache.coyote.Response;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.springframework.util.ReflectionUtils;

public class TomcatFaultInjector
implements FaultInjector {
    private static final byte[] GARBAGE = "lskdu018973t09sylgasjkfg1][]'./.sdlv".getBytes(Charset.forName("UTF-8"));
    private final Response response;
    private SocketWrapperBase<?> socket;

    public TomcatFaultInjector(HttpServletResponse response) {
        this.response = ((org.apache.catalina.connector.Response)this.getField(response, "response")).getCoyoteResponse();
        this.socket = (SocketWrapperBase)this.getField(this.getField(this.response, "outputBuffer"), "socketWrapper");
    }

    private Object getField(Object target, String string) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)string);
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)target);
    }

    public void emptyResponseAndCloseConnection() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked((Throwable)e);
        }
    }

    public void malformedResponseChunk() {
        try {
            this.response.sendHeaders();
            this.response.doWrite(ByteBuffer.wrap(GARBAGE));
            this.socket.flush(true);
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked((Throwable)e);
        }
    }

    public void randomDataAndCloseConnection() {
        try {
            this.socket.write(true, GARBAGE, 0, GARBAGE.length);
            this.socket.flush(true);
            this.socket.close();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked((Throwable)e);
        }
    }
}

