/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingRecoveryStrategy;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.registry.AppRegistryCommon;
import org.springframework.cloud.dataflow.registry.domain.AppRegistration;

public class AppsAfterPipeRecoveryStrategy
extends StacktraceFingerprintingRecoveryStrategy<CheckPointedParseException> {
    private final AppRegistryCommon appRegistry;

    AppsAfterPipeRecoveryStrategy(AppRegistryCommon appRegistry) {
        super(CheckPointedParseException.class, "foo |", "foo | ");
        this.appRegistry = appRegistry;
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        StreamDefinition streamDefinition = new StreamDefinition("__dummy", exception.getExpressionStringUntilCheckpoint());
        CompletionProposal.Factory proposals = CompletionProposal.expanding(dsl);
        for (AppRegistration appRegistration : this.appRegistry.findAll()) {
            if (appRegistration.getType() != ApplicationType.processor && appRegistration.getType() != ApplicationType.sink) continue;
            String expansion = CompletionUtils.maybeQualifyWithLabel(appRegistration.getName(), streamDefinition);
            collector.add(proposals.withSeparateTokens(expansion, "Continue stream definition with a " + appRegistration.getType()));
        }
    }
}

