/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.CompletionUtils;
import org.springframework.cloud.dataflow.completion.ProposalsCollectorSupportUtils;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingRecoveryStrategy;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.StreamAppDefinition;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.registry.AppRegistryCommon;
import org.springframework.cloud.dataflow.registry.domain.AppRegistration;

class ConfigurationPropertyNameAfterDashDashRecoveryStrategy
extends StacktraceFingerprintingRecoveryStrategy<CheckPointedParseException> {
    private final ProposalsCollectorSupportUtils collectorSupport;

    ConfigurationPropertyNameAfterDashDashRecoveryStrategy(AppRegistryCommon appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        super(CheckPointedParseException.class, "file --", "file | foo --");
        this.collectorSupport = new ProposalsCollectorSupportUtils(appRegistry, metadataResolver);
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        String safe = exception.getExpressionStringUntilCheckpoint();
        StreamDefinition streamDefinition = new StreamDefinition("__dummy", safe);
        StreamAppDefinition lastApp = (StreamAppDefinition)streamDefinition.getDeploymentOrderIterator().next();
        AppRegistration appRegistration = this.collectorSupport.findAppRegistration(lastApp.getName(), CompletionUtils.determinePotentialTypes(lastApp));
        if (appRegistration != null) {
            HashSet<String> alreadyPresentOptions = new HashSet<String>(lastApp.getProperties().keySet());
            this.collectorSupport.addPropertiesProposals(safe, "", appRegistration, alreadyPresentOptions, collector, detailLevel);
        }
    }
}

