/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.HashSet;
import java.util.List;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.ProposalsCollectorSupportUtils;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingTaskRecoveryStrategy;
import org.springframework.cloud.dataflow.configuration.metadata.ApplicationConfigurationMetadataResolver;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.core.TaskDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.registry.AppRegistryCommon;
import org.springframework.cloud.dataflow.registry.domain.AppRegistration;

class ConfigurationPropertyNameAfterDashDashTaskRecoveryStrategy
extends StacktraceFingerprintingTaskRecoveryStrategy<CheckPointedParseException> {
    private final ProposalsCollectorSupportUtils collectorSupport;

    ConfigurationPropertyNameAfterDashDashTaskRecoveryStrategy(AppRegistryCommon appRegistry, ApplicationConfigurationMetadataResolver metadataResolver) {
        super(CheckPointedParseException.class, "file --");
        this.collectorSupport = new ProposalsCollectorSupportUtils(appRegistry, metadataResolver);
    }

    @Override
    public void addProposals(String dsl, CheckPointedParseException exception, int detailLevel, List<CompletionProposal> collector) {
        String safe = exception.getExpressionStringUntilCheckpoint();
        TaskDefinition taskDefinition = new TaskDefinition("__dummy", safe);
        AppRegistration appRegistration = this.collectorSupport.findAppRegistration(taskDefinition.getRegisteredAppName(), ApplicationType.task);
        if (appRegistration != null) {
            HashSet<String> alreadyPresentOptions = new HashSet<String>(taskDefinition.getProperties().keySet());
            this.collectorSupport.addPropertiesProposals(safe, "", appRegistration, alreadyPresentOptions, collector, detailLevel);
        }
    }
}

