/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.completion;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.completion.CompletionProposal;
import org.springframework.cloud.dataflow.completion.ConfigurationPropertyNameAfterDashDashRecoveryStrategy;
import org.springframework.cloud.dataflow.completion.StacktraceFingerprintingRecoveryStrategy;
import org.springframework.cloud.dataflow.core.StreamDefinition;
import org.springframework.cloud.dataflow.core.dsl.CheckPointedParseException;
import org.springframework.cloud.dataflow.core.dsl.ParseException;
import org.springframework.util.Assert;

class ExpandOneDashToTwoDashesRecoveryStrategy
extends StacktraceFingerprintingRecoveryStrategy<ParseException> {
    @Autowired
    private ConfigurationPropertyNameAfterDashDashRecoveryStrategy recoveryAfterDashDash;

    public ExpandOneDashToTwoDashesRecoveryStrategy() {
        super(ParseException.class, "file -");
    }

    @Override
    public void addProposals(String dsl, ParseException exception, int detailLevel, List<CompletionProposal> proposals) {
        String withDashDash = dsl + "-";
        try {
            new StreamDefinition("__dummy", withDashDash);
        }
        catch (CheckPointedParseException recoverable) {
            Assert.isTrue((boolean)this.recoveryAfterDashDash.shouldTrigger(withDashDash, (Exception)((Object)recoverable)), (String)"did not tigger after dash-dash");
            this.recoveryAfterDashDash.addProposals(withDashDash, recoverable, detailLevel, proposals);
        }
    }
}

