/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import javax.sql.DataSource;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedBatchConfigurer;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedRunnerJobFactory;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedTaskStepExecutionListener;
import org.springframework.cloud.dataflow.composedtaskrunner.StepBeanDefinitionRegistrar;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableBatchProcessing
@EnableTask
@EnableConfigurationProperties(value={ComposedTaskProperties.class})
@Configuration
@Import(value={StepBeanDefinitionRegistrar.class})
public class ComposedTaskRunnerConfiguration {
    @Autowired
    private ComposedTaskProperties properties;

    @Bean
    public StepExecutionListener composedTaskStepExecutionListener(TaskExplorer taskExplorer) {
        return new ComposedTaskStepExecutionListener(taskExplorer);
    }

    @Bean
    public ComposedRunnerJobFactory composedTaskJob() {
        return new ComposedRunnerJobFactory(this.properties);
    }

    @Bean
    public TaskExecutor taskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.properties.getSplitThreadCorePoolSize());
        taskExecutor.setMaxPoolSize(this.properties.getSplitThreadMaxPoolSize());
        taskExecutor.setKeepAliveSeconds(this.properties.getSplitThreadKeepAliveSeconds());
        taskExecutor.setAllowCoreThreadTimeOut(this.properties.isSplitThreadAllowCoreThreadTimeout());
        taskExecutor.setQueueCapacity(this.properties.getSplitThreadQueueCapacity());
        taskExecutor.setWaitForTasksToCompleteOnShutdown(this.properties.isSplitThreadWaitForTasksToCompleteOnShutdown());
        return taskExecutor;
    }

    @Bean
    public BatchConfigurer getComposedBatchConfigurer(BatchProperties properties, DataSource dataSource, TransactionManagerCustomizers transactionManagerCustomizers) {
        return new ComposedBatchConfigurer(properties, dataSource, transactionManagerCustomizers);
    }
}

