/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ComposedTaskStepExecutionListener
extends StepExecutionListenerSupport {
    private TaskExplorer taskExplorer;
    private static final Log logger = LogFactory.getLog(ComposedTaskStepExecutionListener.class);

    public ComposedTaskStepExecutionListener(TaskExplorer taskExplorer) {
        Assert.notNull((Object)taskExplorer, (String)"taskExplorer must not be null.");
        this.taskExplorer = taskExplorer;
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        ExitStatus result = ExitStatus.COMPLETED;
        logger.info((Object)String.format("AfterStep processing for stepExecution %s", stepExecution.getStepName()));
        Long executionId = (Long)stepExecution.getExecutionContext().get("task-execution-id");
        Assert.notNull((Object)executionId, (String)"TaskLauncherTasklet did not return a task-execution-id.  Check to see if task exists.");
        TaskExecution resultExecution = this.taskExplorer.getTaskExecution(executionId.longValue());
        if (!StringUtils.isEmpty((Object)resultExecution.getExitMessage())) {
            result = new ExitStatus(resultExecution.getExitMessage());
        } else if (resultExecution.getExitCode() != 0) {
            result = ExitStatus.FAILED;
        }
        logger.info((Object)String.format("AfterStep processing complete for stepExecution %s with taskExecution %s", stepExecution.getStepName(), executionId));
        return result;
    }
}

