/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedTaskRunnerStepFactory;
import org.springframework.cloud.dataflow.composedtaskrunner.StepBeanDefinitionRegistrar;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.dataflow.core.dsl.TaskParser;
import org.springframework.cloud.dataflow.core.dsl.TaskVisitor;
import org.springframework.cloud.dataflow.rest.util.DeploymentPropertiesUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class StepBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private Environment env;
    private boolean firstAdd;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        ComposedTaskProperties properties = this.composedTaskProperties();
        String ctrName = this.env.getProperty("spring.cloud.task.name");
        if (ctrName == null) {
            throw new IllegalStateException("spring.cloud.task.name property must have a value.");
        }
        TaskParser taskParser = new TaskParser("bean-registration", properties.getGraph(), false, true);
        Map taskSuffixMap = this.getTaskApps(taskParser);
        for (String taskName : taskSuffixMap.keySet()) {
            for (int taskSuffix = 0; (Integer)taskSuffixMap.get(taskName) >= taskSuffix; ++taskSuffix) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ComposedTaskRunnerStepFactory.class);
                builder.addConstructorArgValue((Object)properties);
                builder.addConstructorArgValue((Object)String.format("%s_%s", taskName, taskSuffix));
                builder.addPropertyValue("taskSpecificProps", (Object)this.getPropertiesForTask(taskName, properties));
                String args = this.getCommandLineArgsForTask(properties.getComposedTaskArguments(), taskName, taskSuffixMap, ctrName);
                builder.addPropertyValue("arguments", (Object)args);
                registry.registerBeanDefinition(String.format("%s_%s", taskName, taskSuffix), (BeanDefinition)builder.getBeanDefinition());
            }
        }
    }

    private String getCommandLineArgsForTask(String arguments, String taskName, Map<String, Integer> taskSuffixMap, String ctrName) {
        String result = "";
        if (!StringUtils.hasText((String)arguments)) {
            return arguments;
        }
        if (arguments.startsWith("\"") && arguments.endsWith("\"")) {
            arguments = arguments.substring(1, arguments.length() - 1);
        }
        arguments = arguments.replace('\n', ' ').replace('\t', ' ');
        this.firstAdd = true;
        try {
            String[] args = CommandLineUtils.translateCommandline((String)arguments);
            String taskNamePrefix = taskName + ".";
            String taskNameNonIdentify = "--" + taskNamePrefix;
            for (String commandLineArg : Arrays.asList(args)) {
                String userPrefix = this.getPrefix(commandLineArg);
                String commandLineArgPrefix = ctrName + "-" + userPrefix;
                String commandLineArgToken = commandLineArgPrefix + ".";
                if (commandLineArgToken.equals(taskNameNonIdentify) || commandLineArgToken.equals(taskNamePrefix)) {
                    result = this.addBlankToCommandLineArgs(result);
                    if (commandLineArg.startsWith(userPrefix)) {
                        result = result.concat(commandLineArg.substring(userPrefix.length() + 1));
                        continue;
                    }
                    result = result + "--" + commandLineArg.substring(userPrefix.length() + 3);
                    continue;
                }
                if (taskSuffixMap.containsKey(commandLineArgPrefix)) continue;
                result = this.addBlankToCommandLineArgs(result);
                if (commandLineArg.contains(" ")) {
                    commandLineArg = commandLineArg.substring(0, commandLineArg.indexOf("=")) + "=\"" + commandLineArg.substring(commandLineArg.indexOf("=") + 1) + "\"";
                }
                result = result.concat(commandLineArg);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to extract command line args for task " + taskName, e);
        }
        return result;
    }

    private String addBlankToCommandLineArgs(String commandArgs) {
        String result = commandArgs;
        if (this.firstAdd) {
            this.firstAdd = false;
        } else {
            result = result.concat(" ");
        }
        return result;
    }

    private String getPrefix(String commandLineArg) {
        String commandLineArgPrefix = !commandLineArg.contains("=") ? commandLineArg : commandLineArg.substring(0, commandLineArg.indexOf("="));
        int indexOfSeparator = commandLineArgPrefix.indexOf(".");
        if (indexOfSeparator > -1) {
            commandLineArgPrefix = commandLineArg.substring(0, indexOfSeparator);
        }
        if (commandLineArgPrefix.startsWith("--")) {
            commandLineArgPrefix = commandLineArgPrefix.substring(2);
        }
        return commandLineArgPrefix;
    }

    private Map<String, String> getPropertiesForTask(String taskName, ComposedTaskProperties properties) {
        Map taskDeploymentProperties = DeploymentPropertiesUtils.parse((String)properties.getComposedTaskProperties());
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        this.updateDeploymentProperties(String.format("app.%s.", taskName), taskDeploymentProperties, deploymentProperties);
        this.updateDeploymentProperties(String.format("deployer.%s.", taskName), taskDeploymentProperties, deploymentProperties);
        return deploymentProperties;
    }

    private void updateDeploymentProperties(String prefix, Map<String, String> taskDeploymentProperties, Map<String, String> deploymentProperties) {
        for (Map.Entry<String, String> entry : taskDeploymentProperties.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            deploymentProperties.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    private ComposedTaskProperties composedTaskProperties() {
        ComposedTaskProperties properties = new ComposedTaskProperties();
        String dataFlowUriString = this.env.getProperty("dataflow-server-uri");
        String maxWaitTime = this.env.getProperty("max-wait-time");
        String intervalTimeBetweenChecks = this.env.getProperty("interval-time-between-checks");
        properties.setGraph(this.env.getProperty("graph"));
        properties.setComposedTaskArguments(this.env.getProperty("composed-task-arguments"));
        properties.setPlatformName(this.env.getProperty("platform-name"));
        properties.setComposedTaskProperties(this.env.getProperty("composed-task-properties"));
        if (maxWaitTime != null) {
            properties.setMaxWaitTime(Integer.valueOf(maxWaitTime).intValue());
        }
        if (intervalTimeBetweenChecks != null) {
            properties.setIntervalTimeBetweenChecks(Integer.valueOf(intervalTimeBetweenChecks).intValue());
        }
        if (dataFlowUriString != null) {
            try {
                properties.setDataflowServerUri(new URI(dataFlowUriString));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid Data Flow URI");
            }
        }
        return properties;
    }

    private Map<String, Integer> getTaskApps(TaskParser taskParser) {
        TaskAppsMapCollector collector = new TaskAppsMapCollector();
        taskParser.parse().accept((TaskVisitor)collector);
        return collector.getTaskApps();
    }
}

