/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner.properties;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties
public class ComposedTaskProperties {
    public static final int MAX_WAIT_TIME_DEFAULT = 0;
    public static final int INTERVAL_TIME_BETWEEN_CHECKS_DEFAULT = 10000;
    public static final int SPLIT_THREAD_CORE_POOL_SIZE_DEFAULT = 4;
    public static final int SPLIT_THREAD_KEEP_ALIVE_SECONDS_DEFAULT = 60;
    public static final int SPLIT_THREAD_MAX_POOL_SIZE_DEFAULT = Integer.MAX_VALUE;
    public static final int SPLIT_THREAD_QUEUE_CAPACITY_DEFAULT = Integer.MAX_VALUE;
    private int maxWaitTime = 0;
    private int intervalTimeBetweenChecks = 10000;
    private URI dataflowServerUri;
    private String dataflowServerUsername;
    private String dataflowServerPassword;
    private String dataflowServerAccessToken;
    private String oauth2ClientCredentialsClientId;
    private String oauth2ClientCredentialsClientSecret;
    private String oauth2ClientCredentialsTokenUri;
    private Set<String> oauth2ClientCredentialsScopes;
    private String graph;
    private String composedTaskProperties;
    private String composedTaskArguments;
    private boolean splitThreadAllowCoreThreadTimeout;
    private int splitThreadCorePoolSize = 4;
    private int splitThreadKeepAliveSeconds = 60;
    private int splitThreadMaxPoolSize = Integer.MAX_VALUE;
    private int splitThreadQueueCapacity = Integer.MAX_VALUE;
    private boolean splitThreadWaitForTasksToCompleteOnShutdown;
    private boolean incrementInstanceEnabled = true;
    private String platformName;

    public ComposedTaskProperties() {
        try {
            this.dataflowServerUri = new URI("http://localhost:9393");
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid Spring Cloud Data Flow Server URI", e);
        }
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public int getIntervalTimeBetweenChecks() {
        return this.intervalTimeBetweenChecks;
    }

    public void setIntervalTimeBetweenChecks(int intervalTimeBetweenChecks) {
        this.intervalTimeBetweenChecks = intervalTimeBetweenChecks;
    }

    public URI getDataflowServerUri() {
        return this.dataflowServerUri;
    }

    public void setDataflowServerUri(URI dataflowServerUri) {
        this.dataflowServerUri = dataflowServerUri;
    }

    public String getDataflowServerUsername() {
        return this.dataflowServerUsername;
    }

    public void setDataflowServerUsername(String dataflowServerUsername) {
        this.dataflowServerUsername = dataflowServerUsername;
    }

    public String getDataflowServerPassword() {
        return this.dataflowServerPassword;
    }

    public void setDataflowServerPassword(String dataflowServerPassword) {
        this.dataflowServerPassword = dataflowServerPassword;
    }

    public String getGraph() {
        return this.graph;
    }

    public void setGraph(String graph) {
        this.graph = graph;
    }

    public String getComposedTaskProperties() {
        return this.composedTaskProperties;
    }

    public void setComposedTaskProperties(String composedTaskProperties) {
        this.composedTaskProperties = composedTaskProperties;
    }

    public String getComposedTaskArguments() {
        return this.composedTaskArguments;
    }

    public void setComposedTaskArguments(String composedTaskArguments) {
        this.composedTaskArguments = composedTaskArguments;
    }

    public boolean isSplitThreadAllowCoreThreadTimeout() {
        return this.splitThreadAllowCoreThreadTimeout;
    }

    public void setSplitThreadAllowCoreThreadTimeout(boolean splitThreadAllowCoreThreadTimeout) {
        this.splitThreadAllowCoreThreadTimeout = splitThreadAllowCoreThreadTimeout;
    }

    public int getSplitThreadCorePoolSize() {
        return this.splitThreadCorePoolSize;
    }

    public void setSplitThreadCorePoolSize(int splitThreadCorePoolSize) {
        this.splitThreadCorePoolSize = splitThreadCorePoolSize;
    }

    public int getSplitThreadKeepAliveSeconds() {
        return this.splitThreadKeepAliveSeconds;
    }

    public void setSplitThreadKeepAliveSeconds(int splitThreadKeepAliveSeconds) {
        this.splitThreadKeepAliveSeconds = splitThreadKeepAliveSeconds;
    }

    public int getSplitThreadMaxPoolSize() {
        return this.splitThreadMaxPoolSize;
    }

    public void setSplitThreadMaxPoolSize(int splitThreadMaxPoolSize) {
        this.splitThreadMaxPoolSize = splitThreadMaxPoolSize;
    }

    public int getSplitThreadQueueCapacity() {
        return this.splitThreadQueueCapacity;
    }

    public void setSplitThreadQueueCapacity(int splitThreadQueueCapacity) {
        this.splitThreadQueueCapacity = splitThreadQueueCapacity;
    }

    public boolean isSplitThreadWaitForTasksToCompleteOnShutdown() {
        return this.splitThreadWaitForTasksToCompleteOnShutdown;
    }

    public void setSplitThreadWaitForTasksToCompleteOnShutdown(boolean splitThreadWaitForTasksToCompleteOnShutdown) {
        this.splitThreadWaitForTasksToCompleteOnShutdown = splitThreadWaitForTasksToCompleteOnShutdown;
    }

    public boolean isIncrementInstanceEnabled() {
        return this.incrementInstanceEnabled;
    }

    public void setIncrementInstanceEnabled(boolean incrementInstanceEnabled) {
        this.incrementInstanceEnabled = incrementInstanceEnabled;
    }

    public String getDataflowServerAccessToken() {
        return this.dataflowServerAccessToken;
    }

    public void setDataflowServerAccessToken(String dataflowServerAccessToken) {
        this.dataflowServerAccessToken = dataflowServerAccessToken;
    }

    public String getOauth2ClientCredentialsClientId() {
        return this.oauth2ClientCredentialsClientId;
    }

    public void setOauth2ClientCredentialsClientId(String oauth2ClientCredentialsClientId) {
        this.oauth2ClientCredentialsClientId = oauth2ClientCredentialsClientId;
    }

    public String getOauth2ClientCredentialsClientSecret() {
        return this.oauth2ClientCredentialsClientSecret;
    }

    public void setOauth2ClientCredentialsClientSecret(String oauth2ClientCredentialsClientSecret) {
        this.oauth2ClientCredentialsClientSecret = oauth2ClientCredentialsClientSecret;
    }

    public String getOauth2ClientCredentialsTokenUri() {
        return this.oauth2ClientCredentialsTokenUri;
    }

    public void setOauth2ClientCredentialsTokenUri(String oauth2ClientCredentialsTokenUri) {
        this.oauth2ClientCredentialsTokenUri = oauth2ClientCredentialsTokenUri;
    }

    public Set<String> getOauth2ClientCredentialsScopes() {
        return this.oauth2ClientCredentialsScopes;
    }

    public void setOauth2ClientCredentialsScopes(Set<String> oauth2ClientCredentialsScopes) {
        this.oauth2ClientCredentialsScopes = oauth2ClientCredentialsScopes;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }
}

