/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.springframework.batch.item.database.support.DataFieldMaxValueIncrementerFactory;
import org.springframework.batch.item.database.support.DefaultDataFieldMaxValueIncrementerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.boot.autoconfigure.batch.BasicBatchConfigurer;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedBatchConfigurer;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.dataflow.composedtaskrunner.support.ComposedTaskException;
import org.springframework.cloud.dataflow.composedtaskrunner.support.SqlServerSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.StringUtils;

public class ComposedBatchConfigurer
extends BasicBatchConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(ComposedBatchConfigurer.class);
    private DataSource incrementerDataSource;
    private Map<String, DataFieldMaxValueIncrementer> incrementerMap;
    private ComposedTaskProperties composedTaskProperties;

    protected ComposedBatchConfigurer(BatchProperties properties, DataSource dataSource, TransactionManagerCustomizers transactionManagerCustomizers, ComposedTaskProperties composedTaskProperties) {
        super(properties, dataSource, transactionManagerCustomizers);
        this.incrementerDataSource = dataSource;
        this.incrementerMap = new HashMap();
        this.composedTaskProperties = composedTaskProperties;
    }

    protected JobRepository createJobRepository() {
        return this.getJobRepository();
    }

    public JobRepository getJobRepository() {
        JobRepositoryFactoryBean factory = new JobRepositoryFactoryBean();
        1 incrementerFactory = new /* Unavailable Anonymous Inner Class!! */;
        factory.setIncrementerFactory((DataFieldMaxValueIncrementerFactory)incrementerFactory);
        factory.setDataSource(this.incrementerDataSource);
        factory.setTransactionManager(this.getTransactionManager());
        factory.setIsolationLevelForCreate(this.composedTaskProperties.getTransactionIsolationLevel());
        try {
            factory.afterPropertiesSet();
            return factory.getObject();
        }
        catch (Exception exception) {
            throw new ComposedTaskException(exception.getMessage());
        }
    }

    private DataFieldMaxValueIncrementer getIncrementerForApp(String incrementerName) {
        DefaultDataFieldMaxValueIncrementerFactory incrementerFactory = new DefaultDataFieldMaxValueIncrementerFactory(this.incrementerDataSource);
        DataFieldMaxValueIncrementer incrementer = null;
        if (this.incrementerMap.containsKey(incrementerName)) {
            return (DataFieldMaxValueIncrementer)this.incrementerMap.get(incrementerName);
        }
        if (this.incrementerDataSource != null) {
            String databaseType;
            try {
                databaseType = DatabaseType.fromMetaData((DataSource)this.incrementerDataSource).name();
            }
            catch (MetaDataAccessException e) {
                throw new IllegalStateException(e);
            }
            if (StringUtils.hasText((String)databaseType) && databaseType.equals("SQLSERVER") && !this.isSqlServerTableSequenceAvailable(incrementerName)) {
                incrementer = new SqlServerSequenceMaxValueIncrementer(this.incrementerDataSource, incrementerName);
                this.incrementerMap.put(incrementerName, incrementer);
            }
        }
        if (incrementer == null) {
            try {
                incrementer = incrementerFactory.getIncrementer(DatabaseType.fromMetaData((DataSource)this.incrementerDataSource).name(), incrementerName);
                this.incrementerMap.put(incrementerName, incrementer);
            }
            catch (Exception exception) {
                logger.warn(exception.getMessage(), (Throwable)exception);
            }
        }
        return incrementer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSqlServerTableSequenceAvailable(String incrementerName) {
        boolean result = false;
        Connection connection = null;
        try {
            connection = this.incrementerDataSource.getConnection();
            DatabaseMetaData metaData = connection.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet tables = metaData.getTables(null, null, "%", types);
            while (tables.next()) {
                if (!tables.getString("TABLE_NAME").equals(incrementerName)) continue;
                result = true;
                break;
            }
        }
        catch (SQLException sqe) {
            logger.warn(sqe.getMessage(), (Throwable)sqe);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqe) {
                    logger.warn(sqe.getMessage(), (Throwable)sqe);
                }
            }
        }
        return result;
    }

    static /* synthetic */ DataFieldMaxValueIncrementer access$000(ComposedBatchConfigurer x0, String x1) {
        return x0.getIncrementerForApp(x1);
    }
}

