/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import javax.sql.DataSource;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedBatchConfigurer;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedRunnerJobFactory;
import org.springframework.cloud.dataflow.composedtaskrunner.ComposedTaskStepExecutionListener;
import org.springframework.cloud.dataflow.composedtaskrunner.StepBeanDefinitionRegistrar;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.task.configuration.EnableTask;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableBatchProcessing
@EnableTask
@EnableConfigurationProperties(value={ComposedTaskProperties.class})
@Configuration
@Import(value={StepBeanDefinitionRegistrar.class})
public class ComposedTaskRunnerConfiguration {
    @Bean
    public StepExecutionListener composedTaskStepExecutionListener(TaskExplorer taskExplorer) {
        return new ComposedTaskStepExecutionListener(taskExplorer);
    }

    @Bean
    public ComposedRunnerJobFactory composedTaskJob(ComposedTaskProperties properties) {
        return new ComposedRunnerJobFactory(properties);
    }

    @Bean
    public TaskExecutor taskExecutor(ComposedTaskProperties properties) {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(properties.getSplitThreadCorePoolSize());
        taskExecutor.setMaxPoolSize(properties.getSplitThreadMaxPoolSize());
        taskExecutor.setKeepAliveSeconds(properties.getSplitThreadKeepAliveSeconds());
        taskExecutor.setAllowCoreThreadTimeOut(properties.isSplitThreadAllowCoreThreadTimeout());
        taskExecutor.setQueueCapacity(properties.getSplitThreadQueueCapacity());
        taskExecutor.setWaitForTasksToCompleteOnShutdown(properties.isSplitThreadWaitForTasksToCompleteOnShutdown());
        return taskExecutor;
    }

    @Bean
    public BatchConfigurer getComposedBatchConfigurer(BatchProperties properties, DataSource dataSource, TransactionManagerCustomizers transactionManagerCustomizers, ComposedTaskProperties composedTaskProperties) {
        return new ComposedBatchConfigurer(properties, dataSource, transactionManagerCustomizers, composedTaskProperties);
    }
}

