/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.dataflow.composedtaskrunner.TaskLauncherTasklet;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.dataflow.core.Base64Utils;
import org.springframework.cloud.task.configuration.TaskConfigurer;
import org.springframework.cloud.task.configuration.TaskProperties;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

public class ComposedTaskRunnerStepFactory
implements FactoryBean<Step> {
    private static final Logger log = LoggerFactory.getLogger(ComposedTaskRunnerStepFactory.class);
    @Autowired
    private ComposedTaskProperties composedTaskProperties;
    private ComposedTaskProperties composedTaskPropertiesFromEnv;
    private String taskName;
    private String taskNameId;
    private Map<String, String> taskSpecificProps = new HashMap();
    private List<String> arguments = new ArrayList();
    @Autowired
    private StepBuilderFactory steps;
    @Autowired
    private StepExecutionListener composedTaskStepExecutionListener;
    @Autowired
    private TaskConfigurer taskConfigurer;
    @Autowired
    private TaskProperties taskProperties;
    @Autowired(required=false)
    private ClientRegistrationRepository clientRegistrations;
    @Autowired(required=false)
    private OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient;

    public ComposedTaskRunnerStepFactory(ComposedTaskProperties composedTaskPropertiesFromEnv, String taskName, String taskNameId) {
        Assert.notNull((Object)composedTaskPropertiesFromEnv, (String)"composedTaskProperties must not be null");
        Assert.hasText((String)taskName, (String)"taskName must not be empty nor null");
        this.composedTaskPropertiesFromEnv = composedTaskPropertiesFromEnv;
        this.taskName = taskName;
        this.taskNameId = taskNameId;
    }

    public void setTaskSpecificProps(Map<String, String> taskSpecificProps) {
        if (taskSpecificProps != null) {
            this.taskSpecificProps = taskSpecificProps;
        }
    }

    public void setArguments(List<String> arguments) {
        if (arguments != null) {
            this.arguments = arguments;
        }
    }

    public Step getObject() throws Exception {
        TaskLauncherTasklet taskLauncherTasklet = new TaskLauncherTasklet(this.clientRegistrations, this.clientCredentialsTokenResponseClient, this.taskConfigurer.getTaskExplorer(), this.composedTaskPropertiesFromEnv, this.taskName, this.taskProperties);
        List argumentsFromAppProperties = Base64Utils.decodeMap((Map)this.composedTaskProperties.getComposedTaskAppArguments()).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("app." + this.taskNameId) || ((String)e.getKey()).startsWith("app.*.")).map(e -> (String)e.getValue()).collect(Collectors.toList());
        List argumentsToUse = Stream.concat(this.arguments.stream(), argumentsFromAppProperties.stream()).collect(Collectors.toList());
        taskLauncherTasklet.setArguments(argumentsToUse);
        log.debug("decoded composed-task-app-properties {}", (Object)this.composedTaskProperties.getComposedTaskAppProperties());
        Map<String, String> propertiesFrom = Base64Utils.decodeMap((Map)this.composedTaskProperties.getComposedTaskAppProperties()).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("app." + this.taskNameId) || ((String)e.getKey()).startsWith("deployer." + this.taskNameId) || ((String)e.getKey()).startsWith("deployer.*")).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
        HashMap<String, String> propertiesToUse = new HashMap<String, String>();
        propertiesToUse.putAll(this.taskSpecificProps);
        propertiesToUse.putAll(propertiesFrom);
        taskLauncherTasklet.setProperties(propertiesToUse);
        log.debug("Properties to use {}", propertiesToUse);
        String stepName = this.taskName;
        return ((AbstractTaskletStepBuilder)this.steps.get(stepName).tasklet((Tasklet)taskLauncherTasklet).transactionAttribute(this.getTransactionAttribute()).listener(this.composedTaskStepExecutionListener)).build();
    }

    private TransactionAttribute getTransactionAttribute() {
        DefaultTransactionAttribute defaultTransactionAttribute = new DefaultTransactionAttribute();
        defaultTransactionAttribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return defaultTransactionAttribute;
    }

    public Class<?> getObjectType() {
        return Step.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

