/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.composedtaskrunner;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.cloud.common.security.core.support.OAuth2AccessTokenProvidingClientHttpRequestInterceptor;
import org.springframework.cloud.dataflow.composedtaskrunner.properties.ComposedTaskProperties;
import org.springframework.cloud.dataflow.composedtaskrunner.support.ComposedTaskException;
import org.springframework.cloud.dataflow.composedtaskrunner.support.TaskExecutionTimeoutException;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.DataFlowTemplate;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.dataflow.rest.util.HttpClientConfigurer;
import org.springframework.cloud.task.configuration.TaskProperties;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2ClientCredentialsGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class TaskLauncherTasklet
implements Tasklet {
    private ComposedTaskProperties composedTaskProperties;
    private TaskExplorer taskExplorer;
    private Map<String, String> properties;
    private List<String> arguments;
    private String taskName;
    private static final Log logger = LogFactory.getLog(TaskLauncherTasklet.class);
    private Long executionId;
    private long timeout;
    private ClientRegistrationRepository clientRegistrations;
    private OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient;
    private TaskOperations taskOperations;
    TaskProperties taskProperties;

    public TaskLauncherTasklet(ClientRegistrationRepository clientRegistrations, OAuth2AccessTokenResponseClient<OAuth2ClientCredentialsGrantRequest> clientCredentialsTokenResponseClient, TaskExplorer taskExplorer, ComposedTaskProperties composedTaskProperties, String taskName, TaskProperties taskProperties) {
        Assert.hasText((String)taskName, (String)"taskName must not be empty nor null.");
        Assert.notNull((Object)taskExplorer, (String)"taskExplorer must not be null.");
        Assert.notNull((Object)composedTaskProperties, (String)"composedTaskProperties must not be null");
        this.taskName = taskName;
        this.taskExplorer = taskExplorer;
        this.composedTaskProperties = composedTaskProperties;
        this.taskProperties = taskProperties;
        this.clientRegistrations = clientRegistrations;
        this.clientCredentialsTokenResponseClient = clientCredentialsTokenResponseClient;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties != null ? properties : new HashMap(0);
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments != null ? arguments : new ArrayList(0);
    }

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) {
        TaskOperations taskOperations = this.taskOperations();
        if (this.executionId == null) {
            this.timeout = System.currentTimeMillis() + (long)this.composedTaskProperties.getMaxWaitTime();
            logger.debug((Object)("Wait time for this task to complete is " + this.composedTaskProperties.getMaxWaitTime()));
            logger.debug((Object)("Interval check time for this task to complete is " + this.composedTaskProperties.getIntervalTimeBetweenChecks()));
            String tmpTaskName = this.taskName.substring(0, this.taskName.lastIndexOf(95));
            ArrayList<String> args = this.arguments;
            ExecutionContext stepExecutionContext = chunkContext.getStepContext().getStepExecution().getExecutionContext();
            if (stepExecutionContext.containsKey("task-arguments")) {
                args = (List)stepExecutionContext.get("task-arguments");
            }
            ArrayList<String> cleansedArgs = new ArrayList<String>();
            if (args != null) {
                for (String argument : args) {
                    if (argument.startsWith("--spring.cloud.task.parent-execution-id=")) continue;
                    cleansedArgs.add(argument);
                }
                args = cleansedArgs;
            }
            if (this.taskProperties.getExecutionid() != null) {
                args.add("--spring.cloud.task.parent-execution-id=" + this.taskProperties.getExecutionid());
            }
            if (StringUtils.hasText((String)this.composedTaskProperties.getPlatformName())) {
                this.properties.put("spring.cloud.dataflow.task.platformName", this.composedTaskProperties.getPlatformName());
            }
            this.executionId = taskOperations.launch(tmpTaskName, this.properties, args);
            stepExecutionContext.put("task-execution-id", (Object)this.executionId);
            stepExecutionContext.put("task-arguments", args);
        } else {
            try {
                Thread.sleep(this.composedTaskProperties.getIntervalTimeBetweenChecks());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e.getMessage(), e);
            }
            TaskExecution taskExecution = this.taskExplorer.getTaskExecution(this.executionId.longValue());
            if (taskExecution != null && taskExecution.getEndTime() != null) {
                if (taskExecution.getExitCode() == null) {
                    throw new UnexpectedJobExecutionException("Task returned a null exit code.");
                }
                if (taskExecution.getExitCode() != 0) {
                    throw new UnexpectedJobExecutionException("Task returned a non zero exit code.");
                }
                return RepeatStatus.FINISHED;
            }
            if (this.composedTaskProperties.getMaxWaitTime() > 0 && System.currentTimeMillis() > this.timeout) {
                throw new TaskExecutionTimeoutException(String.format("Timeout occurred while processing task with Execution Id %s", this.executionId));
            }
        }
        return RepeatStatus.CONTINUABLE;
    }

    public TaskOperations taskOperations() {
        if (this.taskOperations == null) {
            this.taskOperations = this.dataFlowOperations().taskOperations();
            if (this.taskOperations == null) {
                throw new ComposedTaskException("Unable to connect to Data Flow Server to execute task operations. Verify that Data Flow Server's tasks/definitions endpoint can be accessed.");
            }
        }
        return this.taskOperations;
    }

    protected DataFlowOperations dataFlowOperations() {
        RestTemplate restTemplate = DataFlowTemplate.getDefaultDataflowRestTemplate();
        this.validateUsernamePassword(this.composedTaskProperties.getDataflowServerUsername(), this.composedTaskProperties.getDataflowServerPassword());
        HttpClientConfigurer clientHttpRequestFactoryBuilder = null;
        if (this.composedTaskProperties.getOauth2ClientCredentialsClientId() != null || StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerAccessToken()) || StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerUsername()) && StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerPassword())) {
            clientHttpRequestFactoryBuilder = HttpClientConfigurer.create((URI)this.composedTaskProperties.getDataflowServerUri());
        }
        String accessTokenValue = null;
        if (this.composedTaskProperties.getOauth2ClientCredentialsClientId() != null) {
            ClientRegistration clientRegistration = this.clientRegistrations.findByRegistrationId("default");
            OAuth2ClientCredentialsGrantRequest grantRequest = new OAuth2ClientCredentialsGrantRequest(clientRegistration);
            OAuth2AccessTokenResponse res = this.clientCredentialsTokenResponseClient.getTokenResponse((AbstractOAuth2AuthorizationGrantRequest)grantRequest);
            accessTokenValue = res.getAccessToken().getTokenValue();
            logger.debug((Object)"Configured OAuth2 Client Credentials for accessing the Data Flow Server");
        } else if (StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerAccessToken())) {
            accessTokenValue = this.composedTaskProperties.getDataflowServerAccessToken();
            logger.debug((Object)"Configured OAuth2 Access Token for accessing the Data Flow Server");
        } else if (StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerUsername()) && StringUtils.hasText((String)this.composedTaskProperties.getDataflowServerPassword())) {
            accessTokenValue = null;
            clientHttpRequestFactoryBuilder.basicAuthCredentials(this.composedTaskProperties.getDataflowServerUsername(), this.composedTaskProperties.getDataflowServerPassword());
            logger.debug((Object)"Configured basic security for accessing the Data Flow Server");
        } else {
            logger.debug((Object)"Not configuring basic security for accessing the Data Flow Server");
        }
        if (accessTokenValue != null) {
            restTemplate.getInterceptors().add(new OAuth2AccessTokenProvidingClientHttpRequestInterceptor(accessTokenValue));
        }
        if (this.composedTaskProperties.isSkipTlsCertificateVerification()) {
            if (clientHttpRequestFactoryBuilder == null) {
                clientHttpRequestFactoryBuilder = HttpClientConfigurer.create((URI)this.composedTaskProperties.getDataflowServerUri());
            }
            clientHttpRequestFactoryBuilder.skipTlsCertificateVerification();
        }
        if (clientHttpRequestFactoryBuilder != null) {
            restTemplate.setRequestFactory(clientHttpRequestFactoryBuilder.buildClientHttpRequestFactory());
        }
        return new DataFlowTemplate(this.composedTaskProperties.getDataflowServerUri(), restTemplate);
    }

    private void validateUsernamePassword(String userName, String password) {
        if (StringUtils.hasText((String)password) && !StringUtils.hasText((String)userName)) {
            throw new IllegalArgumentException("A password may be specified only together with a username");
        }
        if (!StringUtils.hasText((String)password) && StringUtils.hasText((String)userName)) {
            throw new IllegalArgumentException("A username may be specified only together with a password");
        }
    }
}

