/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry.domain;

import java.net.URI;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.registry.domain.AbstractEntity;
import org.springframework.util.Assert;

@Entity
@Table(name="APP_REGISTRATION")
public class AppRegistration
extends AbstractEntity
implements Comparable<AppRegistration> {
    private String name;
    private ApplicationType type;
    private String version;
    @Lob
    private URI uri;
    @Lob
    private URI metadataUri;
    private Boolean defaultVersion = false;

    public AppRegistration() {
    }

    public AppRegistration(String name, ApplicationType type, URI uri) {
        this(name, type, "", uri, null);
    }

    public AppRegistration(String name, ApplicationType type, URI uri, URI metadataUri) {
        this(name, type, "", uri, metadataUri);
    }

    public AppRegistration(String name, ApplicationType type, String version, URI uri, URI metadataUri) {
        Assert.hasText((String)name, (String)"name is required");
        Assert.notNull((Object)type, (String)"type is required");
        Assert.notNull((Object)version, (String)"version is required");
        Assert.notNull((Object)uri, (String)"uri is required");
        this.name = name;
        this.type = type;
        this.version = version;
        this.uri = uri;
        this.metadataUri = metadataUri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationType getType() {
        return this.type;
    }

    public void setType(ApplicationType type) {
        this.type = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getMetadataUri() {
        return this.metadataUri;
    }

    public void setMetadataUri(URI metadataUri) {
        this.metadataUri = metadataUri;
    }

    public Boolean isDefaultVersion() {
        return this.defaultVersion;
    }

    public void setDefaultVersion(Boolean defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public String toString() {
        return "AppRegistration{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", version='" + this.version + '\'' + ", uri=" + this.uri + ", metadataUri=" + this.metadataUri + '}';
    }

    @Override
    public int compareTo(AppRegistration that) {
        int i = this.type.compareTo((Enum)that.type);
        if (i == 0) {
            i = this.name.compareTo(that.name);
        }
        if (i == 0) {
            i = this.version.compareTo(that.version);
        }
        return i;
    }
}

