/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.registry.service;

import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.dataflow.core.ApplicationType;
import org.springframework.cloud.dataflow.registry.AbstractAppRegistryCommon;
import org.springframework.cloud.dataflow.registry.domain.AppRegistration;
import org.springframework.cloud.dataflow.registry.repository.AppRegistrationRepository;
import org.springframework.cloud.dataflow.registry.service.AppRegistryService;
import org.springframework.cloud.dataflow.registry.support.NoSuchAppRegistrationException;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Transactional
public class DefaultAppRegistryService
extends AbstractAppRegistryCommon
implements AppRegistryService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAppRegistryService.class);
    private final AppRegistrationRepository appRegistrationRepository;

    public DefaultAppRegistryService(AppRegistrationRepository appRegistrationRepository, ResourceLoader resourceLoader, MavenProperties mavenProperties) {
        super(resourceLoader, mavenProperties);
        Assert.notNull((Object)appRegistrationRepository, (String)"'appRegistrationRepository' must not be null");
        Assert.notNull((Object)resourceLoader, (String)"'resourceLoader' must not be null");
        this.appRegistrationRepository = appRegistrationRepository;
    }

    @Override
    public AppRegistration find(String name, ApplicationType type) {
        return this.getDefaultApp(name, type);
    }

    @Override
    public AppRegistration find(String name, ApplicationType type, String version) {
        return this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(name, type, version);
    }

    @Override
    public AppRegistration getDefaultApp(String name, ApplicationType type) {
        return this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndDefaultVersionIsTrue(name, type);
    }

    @Override
    public void setDefaultApp(String name, ApplicationType type, String version) {
        AppRegistration newDefault;
        AppRegistration oldDefault = this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndDefaultVersionIsTrue(name, type);
        if (oldDefault != null) {
            oldDefault.setDefaultVersion(false);
            this.appRegistrationRepository.save(oldDefault);
        }
        if ((newDefault = this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(name, type, version)) == null) {
            throw new NoSuchAppRegistrationException(name, type, version);
        }
        newDefault.setDefaultVersion(true);
        this.appRegistrationRepository.save(newDefault);
    }

    @Override
    public List<AppRegistration> findAll() {
        return this.appRegistrationRepository.findAll();
    }

    @Override
    public Page<AppRegistration> findAllByTypeAndNameIsLike(ApplicationType type, String name, Pageable pageable) {
        if (!StringUtils.hasText((String)name) && type == null) {
            return this.findAll(pageable);
        }
        if (StringUtils.hasText((String)name) && type == null) {
            return this.appRegistrationRepository.findAllByNameContainingIgnoreCase(name, pageable);
        }
        if (StringUtils.hasText((String)name)) {
            return this.appRegistrationRepository.findAllByTypeAndNameContainingIgnoreCase(type, name, pageable);
        }
        return this.appRegistrationRepository.findAllByType(type, pageable);
    }

    @Override
    public Page<AppRegistration> findAll(Pageable pageable) {
        return this.appRegistrationRepository.findAll(pageable);
    }

    @Override
    public AppRegistration save(String name, ApplicationType type, String version, URI uri, URI metadataUri) {
        return this.save(new AppRegistration(name, type, version, uri, metadataUri));
    }

    @Override
    public AppRegistration save(AppRegistration app) {
        AppRegistration appRegistration = this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(app.getName(), app.getType(), app.getVersion());
        if (appRegistration != null) {
            appRegistration.setUri(app.getUri());
            appRegistration.setMetadataUri(app.getMetadataUri());
            return this.appRegistrationRepository.save(appRegistration);
        }
        if (this.getDefaultApp(app.getName(), app.getType()) == null) {
            app.setDefaultVersion(true);
        }
        return this.appRegistrationRepository.save(app);
    }

    @Override
    public void delete(String name, ApplicationType type, String version) {
        this.appRegistrationRepository.deleteAppRegistrationByNameAndTypeAndVersion(name, type, version);
    }

    @Override
    protected boolean isOverwrite(AppRegistration app, boolean overwrite) {
        return overwrite || this.appRegistrationRepository.findAppRegistrationByNameAndTypeAndVersion(app.getName(), app.getType(), app.getVersion()) == null;
    }

    @Override
    public boolean appExist(String name, ApplicationType type) {
        return this.getDefaultApp(name, type) != null;
    }

    @Override
    public boolean appExist(String name, ApplicationType type, String version) {
        return this.find(name, type, version) != null;
    }
}

