/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import org.springframework.cloud.dataflow.rest.client.CompletionOperations;
import org.springframework.cloud.dataflow.rest.resource.CompletionProposalsResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.UriTemplate;
import org.springframework.web.client.RestTemplate;

public class CompletionTemplate
implements CompletionOperations {
    private final RestTemplate restTemplate;
    private final UriTemplate streamCompletionUriTemplate;
    private final UriTemplate taskCompletionUriTemplate;

    public CompletionTemplate(RestTemplate restTemplate, Link streamLink, Link taskLink) {
        this.restTemplate = restTemplate;
        this.streamCompletionUriTemplate = new UriTemplate(streamLink.getHref());
        this.taskCompletionUriTemplate = new UriTemplate(taskLink.getHref());
    }

    @Override
    public CompletionProposalsResource streamCompletions(String prefix, int levelOfDetail) {
        return (CompletionProposalsResource)this.restTemplate.getForObject(this.streamCompletionUriTemplate.expand(new Object[]{prefix, levelOfDetail}), CompletionProposalsResource.class);
    }

    @Override
    public CompletionProposalsResource taskCompletions(String prefix, int levelOfDetail) {
        return (CompletionProposalsResource)this.restTemplate.getForObject(this.taskCompletionUriTemplate.expand(new Object[]{prefix, levelOfDetail}), CompletionProposalsResource.class);
    }
}

