/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client;

import java.io.IOException;
import java.util.List;
import org.springframework.cloud.dataflow.rest.client.DataFlowClientException;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.VndErrors;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.ResponseExtractor;

public class VndErrorResponseErrorHandler
extends DefaultResponseErrorHandler {
    private ResponseExtractor<VndErrors> vndErrorsExtractor;
    private ResponseExtractor<VndErrors.VndError> vndErrorExtractor;

    public VndErrorResponseErrorHandler(List<HttpMessageConverter<?>> messageConverters) {
        this.vndErrorsExtractor = new HttpMessageConverterExtractor(VndErrors.class, messageConverters);
        this.vndErrorExtractor = new HttpMessageConverterExtractor(VndErrors.VndError.class, messageConverters);
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        VndErrors vndErrors = null;
        try {
            vndErrors = HttpStatus.FORBIDDEN.equals((Object)response.getStatusCode()) ? new VndErrors((VndErrors.VndError)this.vndErrorExtractor.extractData(response), new VndErrors.VndError[0]) : (VndErrors)this.vndErrorsExtractor.extractData(response);
        }
        catch (Exception e) {
            super.handleError(response);
        }
        if (vndErrors != null) {
            throw new DataFlowClientException(vndErrors);
        }
        String message = StringUtils.hasText((String)response.getStatusText()) ? response.getStatusText() : String.valueOf(response.getStatusCode());
        throw new DataFlowClientException(new VndErrors(String.valueOf(response.getStatusCode()), message, new Link[0]));
    }
}

