/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.config;

import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.DataFlowTemplate;
import org.springframework.cloud.dataflow.rest.client.config.DataFlowClientProperties;
import org.springframework.cloud.dataflow.rest.client.dsl.Stream;
import org.springframework.cloud.dataflow.rest.client.dsl.StreamBuilder;
import org.springframework.cloud.dataflow.rest.util.HttpClientConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={DataFlowClientProperties.class})
public class DataFlowClientAutoConfiguration {
    @Autowired
    private DataFlowClientProperties properties;
    @Autowired(required=false)
    private RestTemplate restTemplate;

    @Bean
    @ConditionalOnMissingBean(value={DataFlowOperations.class})
    public DataFlowOperations dataFlowOperations() throws Exception {
        RestTemplate template = DataFlowTemplate.prepareRestTemplate(this.restTemplate);
        HttpClientConfigurer httpClientConfigurer = HttpClientConfigurer.create((URI)new URI(this.properties.getServerUri())).skipTlsCertificateVerification(this.properties.isSkipSslValidation());
        if (!StringUtils.isEmpty((Object)this.properties.getAuthentication().getBasic().getUsername()) && !StringUtils.isEmpty((Object)this.properties.getAuthentication().getBasic().getPassword())) {
            httpClientConfigurer.basicAuthCredentials(this.properties.getAuthentication().getBasic().getUsername(), this.properties.getAuthentication().getBasic().getPassword());
            template.setRequestFactory(httpClientConfigurer.buildClientHttpRequestFactory());
        }
        return new DataFlowTemplate(new URI(this.properties.getServerUri()), template);
    }

    @Bean
    @ConditionalOnMissingBean(value={StreamBuilder.class})
    public StreamBuilder streamBuilder(DataFlowOperations dataFlowOperations) {
        return Stream.builder(dataFlowOperations);
    }
}

