/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.dsl;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.dataflow.rest.client.DataFlowOperations;
import org.springframework.cloud.dataflow.rest.client.dsl.StreamApplication;
import org.springframework.cloud.dataflow.rest.client.dsl.StreamBuilder;
import org.springframework.cloud.dataflow.rest.client.dsl.StreamDefinition;
import org.springframework.cloud.dataflow.rest.resource.StreamDefinitionResource;
import org.springframework.cloud.dataflow.rest.resource.StreamDeploymentResource;
import org.springframework.cloud.dataflow.rest.util.DeploymentPropertiesUtils;
import org.springframework.cloud.skipper.domain.PackageIdentifier;
import org.springframework.cloud.skipper.domain.Release;
import org.springframework.util.Assert;

public class Stream {
    private String name;
    private List<StreamApplication> applications;
    private String definition;
    private DataFlowOperations client;

    Stream(String name, List<StreamApplication> applications, String definition, DataFlowOperations client) {
        this.name = name;
        this.applications = applications;
        this.definition = definition;
        this.client = client;
    }

    public String getName() {
        return this.name;
    }

    public static StreamBuilder builder(DataFlowOperations client) {
        return new StreamBuilder(client);
    }

    String getDefinition() {
        return this.definition;
    }

    public void update(String properties) {
        try {
            this.update(DeploymentPropertiesUtils.parseDeploymentProperties((String)properties, null, (int)0));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not update Stream with property string = " + properties, e);
        }
    }

    public void update(Map<String, String> propertiesToUse) {
        PackageIdentifier packageIdentifier = new PackageIdentifier();
        packageIdentifier.setPackageName(this.name);
        this.client.streamOperations().updateStream(this.name, this.name, packageIdentifier, propertiesToUse, false, null);
        StreamDeploymentResource info = this.client.streamOperations().info(this.name);
        this.name = info.getStreamName();
        this.definition = info.getDslText();
    }

    public void rollback(int streamVersion) {
        this.client.streamOperations().rollbackStream(this.name, streamVersion);
        StreamDeploymentResource info = this.client.streamOperations().info(this.name);
        this.name = info.getStreamName();
        this.definition = info.getDslText();
    }

    public void undeploy() {
        this.client.streamOperations().undeploy(this.name);
    }

    public void destroy() {
        this.client.streamOperations().destroy(this.name);
    }

    public Map<Integer, String> history() {
        Collection<Release> history = this.client.streamOperations().history(this.name);
        return history.stream().collect(Collectors.toMap(r -> r.getVersion(), r -> r.getInfo().getStatus().getStatusCode().toString().toLowerCase()));
    }

    public String manifest(int streamVersion) {
        return this.client.streamOperations().getManifest(this.name, streamVersion);
    }

    public String getStatus() {
        StreamDefinitionResource resource = this.client.streamOperations().getStreamDefinition(this.name);
        return resource.getStatus();
    }

    static abstract class BaseBuilder {
        protected StreamApplication application;
        protected StreamNameBuilder parent;

        public BaseBuilder(StreamApplication application, StreamNameBuilder parent) {
            this.application = application;
            this.parent = parent;
            this.parent.addApplication(application);
        }
    }

    public static class SinkBuilder
    extends BaseBuilder {
        private SinkBuilder(StreamApplication application, StreamNameBuilder parent) {
            super(application, parent);
        }

        public StreamDefinition create() {
            return this.parent.create();
        }
    }

    public static class ProcessorBuilder
    extends BaseBuilder {
        private ProcessorBuilder(StreamApplication application, StreamNameBuilder parent) {
            super(application, parent);
        }

        public ProcessorBuilder processor(StreamApplication processor) {
            Assert.notNull((Object)processor, (String)"Processor application can't be null");
            return new ProcessorBuilder(processor.type(StreamApplication.ApplicationType.PROCESSOR), this.parent);
        }

        public SinkBuilder sink(StreamApplication sink) {
            Assert.notNull((Object)sink, (String)"Sink application can't be null");
            return new SinkBuilder(sink.type(StreamApplication.ApplicationType.SINK), this.parent);
        }
    }

    public static class SourceBuilder
    extends BaseBuilder {
        private SourceBuilder(StreamApplication source, StreamNameBuilder parent) {
            super(source, parent);
        }

        public ProcessorBuilder processor(StreamApplication processor) {
            Assert.notNull((Object)processor, (String)"Processor application can't be null");
            return new ProcessorBuilder(processor.type(StreamApplication.ApplicationType.PROCESSOR), this.parent);
        }

        public SinkBuilder sink(StreamApplication sink) {
            Assert.notNull((Object)sink, (String)"Sink application can't be null");
            return new SinkBuilder(sink.type(StreamApplication.ApplicationType.SINK), this.parent);
        }
    }

    public static class StreamDefinitionBuilder {
        private String name;
        private DataFlowOperations client;
        private String definition;

        private StreamDefinitionBuilder(String name, DataFlowOperations client, String definition) {
            this.name = name;
            this.client = client;
            this.definition = definition;
        }

        public StreamDefinition create() {
            return new StreamDefinition(this.name, this.client, this.definition, Collections.emptyList());
        }
    }

    public static class StreamNameBuilder {
        private String name;
        private List<StreamApplication> applications = new LinkedList<StreamApplication>();
        private DataFlowOperations client;
        private String definition;

        StreamNameBuilder(String name, DataFlowOperations client) {
            this.client = client;
            Assert.hasLength((String)name, (String)"Stream name can't be empty");
            this.name = name;
        }

        public SourceBuilder source(StreamApplication source) {
            Assert.notNull((Object)source, (String)"Source application can't be null");
            return new SourceBuilder(source.type(StreamApplication.ApplicationType.SOURCE), this);
        }

        public StreamDefinitionBuilder definition(String definiton) {
            Assert.hasLength((String)this.name, (String)"Stream definition can't be empty");
            this.definition = definiton;
            return new StreamDefinitionBuilder(this.name, this.client, this.definition);
        }

        private StreamDefinition create() {
            return new StreamDefinition(this.name, this.client, this.definition, this.applications);
        }

        private void addApplication(StreamApplication application) {
            if (this.contains(application)) {
                throw new IllegalStateException("There's already an application with the same definition in this stream");
            }
            this.applications.add(application);
        }

        private boolean contains(StreamApplication application) {
            for (StreamApplication app : this.applications) {
                if (!app.getType().equals((Object)application.getType()) || !app.getIdentity().equals(application.getIdentity())) continue;
                return true;
            }
            return false;
        }
    }
}

