/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.client.dsl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StreamApplication {
    private final String deployerPrefix = "deployer.%s.";
    private final String name;
    private String label;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, Object> deploymentProperties = new HashMap<String, Object>();
    private ApplicationType type;

    public StreamApplication(String name) {
        Assert.hasLength((String)name, (String)"Application name can't be empty");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public StreamApplication label(String label) {
        Assert.hasLength((String)label, (String)"Label can't be empty");
        this.label = label;
        return this;
    }

    public StreamApplication addProperty(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public StreamApplication addDeploymentProperty(String key, Object value) {
        this.deploymentProperties.put(key, value);
        return this;
    }

    public StreamApplication addProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public StreamApplication type(ApplicationType type) {
        this.type = type;
        return this;
    }

    public Map<String, Object> getDeploymentProperties() {
        HashMap<String, Object> formattedProperties = new HashMap<String, Object>();
        String id = StringUtils.isEmpty((Object)this.label) ? this.name : this.label;
        for (Map.Entry<String, Object> entry : this.deploymentProperties.entrySet()) {
            formattedProperties.put(String.format("deployer.%s.", id) + entry.getKey(), entry.getValue());
        }
        return formattedProperties;
    }

    public String getIdentity() {
        if (!StringUtils.isEmpty((Object)this.label)) {
            return this.label + ": " + this.name;
        }
        return this.name;
    }

    public String getDefinition() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getIdentity());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            buffer.append(" --" + entry.getKey() + "=" + entry.getValue());
        }
        return buffer.toString();
    }

    public ApplicationType getType() {
        return this.type;
    }

    public String toString() {
        return this.getDefinition();
    }

    public static enum ApplicationType {
        SOURCE,
        PROCESSOR,
        SINK;

    }
}

