/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.job.support;

import org.springframework.batch.core.step.item.ChunkOrientedTasklet;
import org.springframework.batch.core.step.tasklet.CallableTaskletAdapter;
import org.springframework.batch.core.step.tasklet.MethodInvokingTaskletAdapter;
import org.springframework.batch.core.step.tasklet.SystemCommandTasklet;
import org.springframework.util.StringUtils;

public enum TaskletType {
    CHUNK_ORIENTED_TASKLET(ChunkOrientedTasklet.class.getName(), "Chunk Oriented Step"),
    SYSTEM_COMMAND_TASKLET(SystemCommandTasklet.class.getName(), "System Command Step"),
    CALLABLE_TASKLET_ADAPTER(CallableTaskletAdapter.class.getName(), "Callable Tasklet Adapter Step"),
    METHOD_INVOKING_TASKLET_ADAPTER(MethodInvokingTaskletAdapter.class.getName(), "Method Invoking Tasklet Adapter Step"),
    UNKNOWN("", "");

    private final String className;
    private final String displayName;

    private TaskletType(String className, String displayName) {
        this.className = className;
        this.displayName = displayName;
    }

    public static TaskletType fromClassName(String className) {
        TaskletType type = UNKNOWN;
        if (StringUtils.hasText((String)className)) {
            String name = className.trim();
            for (TaskletType curType : TaskletType.values()) {
                if (!curType.className.equals(name)) continue;
                type = curType;
                break;
            }
        }
        return type;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

