/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.resource;

import java.util.Collections;
import java.util.List;
import org.springframework.cloud.dataflow.rest.resource.JobExecutionResource;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;

public class JobInstanceResource
extends ResourceSupport {
    private String jobName;
    private long jobInstanceId;
    private List<JobExecutionResource> jobExecutions;

    private JobInstanceResource() {
    }

    public JobInstanceResource(String jobName, long jobInstanceId, List<JobExecutionResource> taskJobExecutions) {
        Assert.hasText((String)jobName, (String)"jobName must not be empty nor null");
        this.jobName = jobName;
        this.jobInstanceId = jobInstanceId;
        if (taskJobExecutions == null) {
            this.jobExecutions = Collections.emptyList();
        } else {
            this.jobExecutions = taskJobExecutions;
            this.jobExecutions = Collections.unmodifiableList(this.jobExecutions);
        }
    }

    public String getJobName() {
        return this.jobName;
    }

    public long getJobInstanceId() {
        return this.jobInstanceId;
    }

    public List<JobExecutionResource> getJobExecutions() {
        return this.jobExecutions;
    }

    public static class Page
    extends PagedResources<JobInstanceResource> {
    }
}

