/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.util.Assert;

public class ScheduleInfoResource
extends ResourceSupport {
    private String scheduleName;
    private String taskDefinitionName;
    private Map<String, String> scheduleProperties = new HashMap<String, String>();

    protected ScheduleInfoResource() {
    }

    public ScheduleInfoResource(String scheduleName, String taskDefinitionName, Map<String, String> scheduleProperties) {
        Assert.hasText((String)scheduleName, (String)"scheduleName must not be null or empty");
        Assert.hasText((String)taskDefinitionName, (String)"taskDefinitionName must not be null or empty");
        Assert.notNull(scheduleProperties, (String)"schedulerProperties must not be null.");
        this.scheduleName = scheduleName;
        this.scheduleProperties.putAll(scheduleProperties);
        this.taskDefinitionName = taskDefinitionName;
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public String getTaskDefinitionName() {
        return this.taskDefinitionName;
    }

    public void setTaskDefinitionName(String taskDefinitionName) {
        this.taskDefinitionName = taskDefinitionName;
    }

    public Map<String, String> getScheduleProperties() {
        return Collections.unmodifiableMap(this.scheduleProperties);
    }

    public void setScheduleProperties(Map<String, String> scheduleProperties) {
        this.scheduleProperties.clear();
        this.scheduleProperties.putAll(scheduleProperties);
    }

    public static class Page
    extends PagedResources<ScheduleInfoResource> {
    }
}

