/*
 * Copyright 2015-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.dataflow.rest.resource;

import java.util.Map;

import org.springframework.cloud.dataflow.core.StreamRuntimePropertyKeys;
import org.springframework.hateoas.RepresentationModel;

/**
 * REST representation for an AppInstanceStatus.
 *
 * @author Eric Bottard
 * @author Mark Fisher
 */
public class AppInstanceStatusResource extends RepresentationModel<AppInstanceStatusResource> {

	private String instanceId;

	private String state;

	private Map<String, String> attributes;

	private AppInstanceStatusResource() {
		// noarg constructor for serialization
	}

	public AppInstanceStatusResource(String instanceId, String state, Map<String, String> attributes) {
		this.instanceId = instanceId;
		this.state = state;
		this.attributes = attributes;
	}

	public String getInstanceId() {
		return instanceId;
	}

	public void setInstanceId(String instanceId) {
		this.instanceId = instanceId;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getGuid() {
		if (this.getAttributes() != null && this.getAttributes().containsKey(StreamRuntimePropertyKeys.ATTRIBUTE_GUID)) {
			return this.getAttributes().get(StreamRuntimePropertyKeys.ATTRIBUTE_GUID);
		}
		return this.getInstanceId();
	}

	public Map<String, String> getAttributes() {
		return attributes;
	}

	public void setAttributes(Map<String, String> attributes) {
		this.attributes = attributes;
	}
}
