/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.rest.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.dataflow.rest.job.TaskJobExecutionRel;
import org.springframework.cloud.dataflow.rest.resource.TaskExecutionStatus;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.Assert;

public class TaskExecutionResource
extends RepresentationModel<TaskExecutionResource> {
    private long executionId;
    private Integer exitCode;
    private String taskName;
    private Date startTime;
    private Date endTime;
    private String exitMessage;
    private List<String> arguments;
    private List<Long> jobExecutionIds;
    private String errorMessage;
    private String externalExecutionId;
    private Long parentExecutionId;
    private String resourceUrl;
    private Map<String, String> appProperties;
    private Map<String, String> deploymentProperties;

    public TaskExecutionResource() {
        this.arguments = new ArrayList<String>();
    }

    public TaskExecutionResource(TaskJobExecutionRel taskJobExecutionRel) {
        Assert.notNull((Object)taskJobExecutionRel, (String)"taskJobExecutionDTO must not be null");
        this.executionId = taskJobExecutionRel.getTaskExecution().getExecutionId();
        this.parentExecutionId = taskJobExecutionRel.getTaskExecution().getParentExecutionId();
        this.exitCode = taskJobExecutionRel.getTaskExecution().getExitCode();
        this.taskName = taskJobExecutionRel.getTaskExecution().getTaskName();
        this.exitMessage = taskJobExecutionRel.getTaskExecution().getExitMessage();
        this.arguments = Collections.unmodifiableList(taskJobExecutionRel.getTaskExecution().getArguments());
        this.startTime = taskJobExecutionRel.getTaskExecution().getStartTime();
        this.endTime = taskJobExecutionRel.getTaskExecution().getEndTime();
        this.errorMessage = taskJobExecutionRel.getTaskExecution().getErrorMessage();
        this.externalExecutionId = taskJobExecutionRel.getTaskExecution().getExternalExecutionId();
        this.jobExecutionIds = taskJobExecutionRel.getJobExecutionIds() == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Long>(taskJobExecutionRel.getJobExecutionIds()));
        if (taskJobExecutionRel.getTaskManifest() != null) {
            this.resourceUrl = taskJobExecutionRel.getTaskManifest().getTaskDeploymentRequest().getResource().toString();
            this.appProperties = taskJobExecutionRel.getTaskManifest().getTaskDeploymentRequest().getDefinition().getProperties();
            this.deploymentProperties = taskJobExecutionRel.getTaskManifest().getTaskDeploymentRequest().getDeploymentProperties();
        }
    }

    public TaskExecutionResource(TaskExecution taskExecution) {
        Assert.notNull((Object)taskExecution, (String)"taskExecution must not be null");
        this.executionId = taskExecution.getExecutionId();
        this.exitCode = taskExecution.getExitCode();
        this.taskName = taskExecution.getTaskName();
        this.exitMessage = taskExecution.getExitMessage();
        this.arguments = Collections.unmodifiableList(taskExecution.getArguments());
        this.startTime = taskExecution.getStartTime();
        this.endTime = taskExecution.getEndTime();
        this.errorMessage = taskExecution.getErrorMessage();
        this.externalExecutionId = taskExecution.getExternalExecutionId();
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<Long> getJobExecutionIds() {
        return this.jobExecutionIds;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getExternalExecutionId() {
        return this.externalExecutionId;
    }

    public Long getParentExecutionId() {
        return this.parentExecutionId;
    }

    public String getResourceUrl() {
        return this.resourceUrl;
    }

    public Map<String, String> getAppProperties() {
        return this.appProperties;
    }

    public Map<String, String> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public TaskExecutionStatus getTaskExecutionStatus() {
        if (this.startTime == null) {
            return TaskExecutionStatus.UNKNOWN;
        }
        if (this.endTime == null) {
            return TaskExecutionStatus.RUNNING;
        }
        return this.exitCode == null ? TaskExecutionStatus.RUNNING : (this.exitCode == 0 ? TaskExecutionStatus.COMPLETE : TaskExecutionStatus.ERROR);
    }

    public static class Page
    extends PagedModel<TaskExecutionResource> {
    }
}

