/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.dataflow.scheduler.launcher.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.dataflow.rest.client.DataFlowClientException;
import org.springframework.cloud.dataflow.rest.client.TaskOperations;
import org.springframework.cloud.dataflow.rest.resource.LauncherResource;
import org.springframework.cloud.dataflow.scheduler.launcher.configuration.SchedulerTaskLauncherException;
import org.springframework.cloud.dataflow.scheduler.launcher.configuration.SchedulerTaskLauncherProperties;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.hateoas.PagedModel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SchedulerTaskLauncher {
    static final String TASK_PLATFORM_NAME = "spring.cloud.dataflow.task.platformName";
    public static final String COMMAND_ARGUMENT_PREFIX = "cmdarg";
    private static final Log log = LogFactory.getLog(SchedulerTaskLauncher.class);
    private final String taskName;
    private final String platformName;
    private final SchedulerTaskLauncherProperties schedulerTaskLauncherProperties;
    private final TaskOperations taskOperations;
    private Environment environment;

    public SchedulerTaskLauncher(TaskOperations taskOperations, SchedulerTaskLauncherProperties schedulerTaskLauncherProperties, Environment environment) {
        Assert.notNull((Object)taskOperations, (String)"`taskOperations` must not be null");
        Assert.notNull((Object)schedulerTaskLauncherProperties, (String)"`schedulerTaskLauncherProperties` must not be null");
        Assert.notNull((Object)environment, (String)"`environment` must not be null");
        Assert.hasText((String)schedulerTaskLauncherProperties.getTaskName(), (String)"`taskName` must not be empty or null");
        Assert.hasText((String)schedulerTaskLauncherProperties.getPlatformName(), (String)"`platformName` must not be empty or null");
        this.taskOperations = taskOperations;
        this.taskName = schedulerTaskLauncherProperties.getTaskName();
        this.platformName = schedulerTaskLauncherProperties.getPlatformName();
        this.schedulerTaskLauncherProperties = schedulerTaskLauncherProperties;
        this.environment = environment;
    }

    public void launchTask(String ... args) {
        this.verifyTaskPlatform(this.taskOperations);
        List argList = this.extractLaunchArgs(args);
        try {
            log.info((Object)String.format("Launching Task %s on the %s platform.", this.taskName, this.platformName));
            this.taskOperations.launch(this.taskName, this.enrichDeploymentProperties(this.getDeploymentProperties()), argList, null);
        }
        catch (DataFlowClientException e) {
            throw new SchedulerTaskLauncherException((Throwable)e);
        }
    }

    private List<String> extractLaunchArgs(String ... args) {
        ArrayList<String> result = new ArrayList<String>();
        for (String arg : args) {
            String prefix = "cmdarg." + this.schedulerTaskLauncherProperties.getTaskLauncherPropertyPrefix() + ".";
            if (!arg.startsWith(prefix)) continue;
            result.add(arg.substring(prefix.length()));
        }
        return result;
    }

    private Map<String, String> enrichDeploymentProperties(Map<String, String> deploymentProperties) {
        HashMap<String, String> enrichedProperties = new HashMap<String, String>(deploymentProperties);
        if (!deploymentProperties.containsKey(TASK_PLATFORM_NAME)) {
            enrichedProperties.put(TASK_PLATFORM_NAME, this.platformName);
        }
        return enrichedProperties;
    }

    private Map<String, String> getDeploymentProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        String taskLauncherPrefix = this.schedulerTaskLauncherProperties.getTaskLauncherPropertyPrefix() + ".";
        MutablePropertySources propSrcs = ((AbstractEnvironment)this.environment).getPropertySources();
        StreamSupport.stream(propSrcs.spliterator(), false).filter(ps -> ps instanceof EnumerablePropertySource).map(ps -> ((EnumerablePropertySource)ps).getPropertyNames()).flatMap(Arrays::stream).filter(propName -> propName.startsWith(taskLauncherPrefix)).forEach(propName -> {
            String trimmedPropName = propName.substring(taskLauncherPrefix.length());
            props.put(trimmedPropName, this.environment.getProperty(propName));
        });
        return props;
    }

    public void verifyTaskPlatform(TaskOperations taskOperations) {
        PagedModel launchers = taskOperations.listPlatforms();
        boolean validPlatform = false;
        ArrayList<String> currentPlatforms = new ArrayList<String>();
        for (LauncherResource launcherResource : launchers) {
            currentPlatforms.add(launcherResource.getName());
            if (!launcherResource.getName().equals(this.platformName)) continue;
            validPlatform = true;
            break;
        }
        this.assertValidPlatform(validPlatform, currentPlatforms);
    }

    private void assertValidPlatform(boolean validPlatform, List<String> currentPlatforms) {
        Assert.notEmpty(currentPlatforms, (String)"The Data Flow Server has no task platforms configured");
        Assert.isTrue((boolean)validPlatform, (String)String.format("The task launcher's platform name '%s' does not match one of the Data Flow server's configured task platforms: [%s].", this.platformName, StringUtils.collectionToCommaDelimitedString(currentPlatforms)));
    }
}

