/*
 * Copyright 2016-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.cloud.deployer.spi.local;

import java.util.Map;
import java.util.Optional;

import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;

/**
 * Strategy interface for Execution Command builder.
 *
 * @author Ilayaperumal Gopinathan
 * @author Thomas Risberg
 */
public interface CommandBuilder {

	/**
	 * Builds the execution command for an application.
	 *
	 * @param request the request for the application to execute
	 * @param appInstanceEnv the env vars tha might be needed when building the execution command
	 * @param appProperties the app properties to use when building the execution command
	 * @return the build command as a string array
	 */
	String[] buildExecutionCommand(AppDeploymentRequest request,
								   Map<String, String> appInstanceEnv,
								   Map<String, String> appProperties,
								   Optional<Integer> appInstanceNumber);
}
