/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.registry;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.registry.UriRegistry;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;

public class UriRegistryPopulator
implements ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(UriRegistryPopulator.class);
    private volatile ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Map<String, URI> populateRegistry(boolean overwrite, UriRegistry registry, String ... resourceUris) {
        Assert.notEmpty((Object[])resourceUris);
        HashMap<String, URI> registered = new HashMap<String, URI>();
        for (String resourceUri : resourceUris) {
            Resource resource = this.resourceLoader.getResource(resourceUri);
            Properties properties = new Properties();
            try (InputStream is = resource.getInputStream();){
                properties.load(is);
                for (String key : properties.stringPropertyNames()) {
                    try {
                        URI uri = new URI(properties.getProperty(key));
                        if (!overwrite) {
                            try {
                                if (registry.find(key) != null) {
                                    continue;
                                }
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                        }
                        registry.register(key, uri);
                        registered.put(key, uri);
                    }
                    catch (URISyntaxException e) {
                        logger.warn(String.format("'%s' for '%s' is not a properly formed URI", properties.getProperty(key), key), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return registered;
    }
}

