/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.support;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.deployer.resource.support.DownloadingUrlResourceLoader;
import org.springframework.cloud.deployer.resource.support.ResourceNotResolvedException;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class DelegatingResourceLoader
implements ResourceLoader,
ResourceLoaderAware {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingResourceLoader.class);
    private final ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private final Map<String, ResourceLoader> loaders;
    private ResourceLoader defaultResourceLoader = new DefaultResourceLoader();
    private final File cacheDirectory;
    private static final String DEFAULT_CACHE_PREFIX = "deployer-resource-cache";

    public DelegatingResourceLoader() {
        this(null, null);
    }

    public DelegatingResourceLoader(Map<String, ResourceLoader> loaders) {
        this(loaders, null);
    }

    public DelegatingResourceLoader(Map<String, ResourceLoader> loaders, File cacheDirectory) {
        this.loaders = CollectionUtils.isEmpty(loaders) ? Collections.emptyMap() : Collections.unmodifiableMap(loaders);
        this.cacheDirectory = this.initCacheDirectory(cacheDirectory);
    }

    public void setResourceLoader(ResourceLoader contextResourceLoader) {
        if (contextResourceLoader != null && contextResourceLoader != this) {
            this.defaultResourceLoader = contextResourceLoader;
        }
    }

    public Resource getResource(String location) {
        try {
            URI uri = new URI(location);
            String scheme = uri.getScheme();
            Assert.notNull((Object)scheme, (String)"a scheme (prefix) is required");
            Object loader = this.loaders.get(scheme);
            if (loader == null) {
                loader = scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https") ? new DownloadingUrlResourceLoader() : this.defaultResourceLoader;
            }
            return loader.getResource(location);
        }
        catch (Exception e) {
            throw new ResourceNotResolvedException(e.getMessage(), e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private File initCacheDirectory(File cacheDirectory) {
        try {
            if (cacheDirectory == null) {
                Path tempDirectory = Files.createTempDirectory(DEFAULT_CACHE_PREFIX, new FileAttribute[0]);
                return tempDirectory.toFile();
            }
            cacheDirectory.mkdirs();
            return cacheDirectory;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to create cache directory", e);
        }
    }

    private static boolean existsAsFile(Resource resource) {
        try {
            resource.getFile();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

