/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.function.context.AbstractSpringFunctionAdapterInitializer;
import reactor.core.publisher.Flux;

public class SpringBootStreamHandler
extends AbstractSpringFunctionAdapterInitializer<Context>
implements RequestStreamHandler {
    @Autowired(required=false)
    private ObjectMapper mapper;

    public SpringBootStreamHandler() {
    }

    public SpringBootStreamHandler(Class<?> configurationClass) {
        super(configurationClass);
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        this.initialize(context);
        Object value = this.convertStream(input);
        Publisher flux = this.apply((Publisher)this.extract(value));
        this.mapper.writeValue(output, this.result(value, flux));
    }

    protected void initialize(Context context) {
        super.initialize((Object)context);
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
        }
    }

    private Flux<?> extract(Object input) {
        if (input instanceof Collection) {
            return Flux.fromIterable((Iterable)((Iterable)input));
        }
        return Flux.just((Object)input);
    }

    private Object convertStream(InputStream input) {
        Object convertedResult = input;
        try {
            Class inputType = this.getInputType();
            if (!InputStream.class.isAssignableFrom(inputType)) {
                convertedResult = this.mapper.readValue(input, inputType);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot convert event stream", e);
        }
        return convertedResult;
    }
}

