/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.azure;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.OutputBinding;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.adapter.azure.AzureSpringFunctionInitializer;
import reactor.core.publisher.Flux;

public class AzureSpringBootRequestHandler<I, O>
extends AzureSpringFunctionInitializer {
    public AzureSpringBootRequestHandler(Class<?> configurationClass) {
        super(configurationClass);
    }

    public AzureSpringBootRequestHandler() {
    }

    public O handleRequest(I input, ExecutionContext context) {
        String name = null;
        try {
            if (context != null) {
                name = context.getFunctionName();
                context.getLogger().info("Handler processing a request for: " + name);
            }
            this.initialize(context);
            Function<Publisher<?>, Publisher<?>> function = this.lookup(name);
            Flux<Publisher<?>> events = this.extract(function, this.convertEvent(input));
            Publisher<?> output = function.apply((Publisher<?>)events);
            O o = this.result(function, input, output);
            return o;
        }
        catch (Throwable ex) {
            if (context != null) {
                context.getLogger().throwing(this.getClass().getName(), "handle", ex);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            throw new UndeclaredThrowableException(ex);
        }
        finally {
            if (context != null) {
                context.getLogger().fine("Handler processed a request for: " + name);
            }
        }
    }

    public void handleOutput(I input, OutputBinding<O> binding, ExecutionContext context) {
        O result = this.handleRequest(input, context);
        binding.setValue(result);
    }

    protected Object convertEvent(I input) {
        return input;
    }

    private Flux<?> extract(Function<?, ?> function, Object input) {
        if (!this.isSingleInput(function, input) && input instanceof Collection) {
            return Flux.fromIterable((Iterable)((Iterable)input));
        }
        return Flux.just((Object)input);
    }

    private O result(Function<?, ?> function, Object input, Publisher<?> output) {
        ArrayList<Object> value;
        ArrayList<O> result = new ArrayList<O>();
        for (Object value2 : Flux.from(output).toIterable()) {
            result.add(this.convertOutput(value2));
        }
        if (this.isSingleInput(function, input) && result.size() == 1) {
            value = result.get(0);
            return (O)value;
        }
        if (this.isSingleOutput(function, input) && result.size() == 1) {
            value = result.get(0);
            return (O)value;
        }
        value = result;
        return (O)value;
    }

    protected O convertOutput(Object output) {
        return (O)output;
    }
}

