/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.gcp;

import com.google.cloud.functions.Context;
import com.google.cloud.functions.HttpFunction;
import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import com.google.cloud.functions.RawBackgroundFunction;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.context.AbstractSpringFunctionAdapterInitializer;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;

public class FunctionInvoker
extends AbstractSpringFunctionAdapterInitializer<HttpRequest>
implements HttpFunction,
RawBackgroundFunction {
    private static final Log log = LogFactory.getLog(FunctionInvoker.class);
    private String functionName = "";

    public FunctionInvoker() {
        this.init();
    }

    public FunctionInvoker(Class<?> configurationClass) {
        super(configurationClass);
        this.init();
    }

    private void init() {
        if (System.getenv().containsKey("spring.cloud.function.definition")) {
            this.functionName = System.getenv("spring.cloud.function.definition");
        }
        if (!System.getenv().containsKey("spring.cloud.function.preferred-json-mapper")) {
            System.setProperty("spring.cloud.function.preferred-json-mapper", "gson");
        }
        Thread.currentThread().setContextClassLoader(FunctionInvoker.class.getClassLoader());
        this.initialize(null);
    }

    private <I> Function<Message<I>, Message<byte[]>> lookupFunction() {
        Function function = (Function)this.catalog.lookup(this.functionName, new String[]{MimeTypeUtils.APPLICATION_JSON.toString()});
        Assert.notNull((Object)function, (String)("'function' with name '" + this.functionName + "' must not be null"));
        return function;
    }

    public void service(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        Message message;
        Function function = this.lookupFunction();
        Message<byte[]> result = function.apply(message = this.getInputType() == Void.class || this.getInputType() == null ? null : MessageBuilder.withPayload((Object)httpRequest.getReader()).copyHeaders(httpRequest.getHeaders()).build());
        if (result != null) {
            httpResponse.getWriter().write(new String((byte[])result.getPayload(), StandardCharsets.UTF_8));
            for (Map.Entry header : result.getHeaders().entrySet()) {
                httpResponse.appendHeader((String)header.getKey(), header.getValue().toString());
            }
        }
    }

    public void accept(String json, Context context) {
        Message message;
        Function function = this.lookupFunction();
        Message<byte[]> result = function.apply(message = this.getInputType() == Void.class ? null : MessageBuilder.withPayload((Object)json).setHeader("gcf_context", (Object)context).build());
        if (result != null) {
            log.info((Object)("Dropping background function result: " + new String((byte[])result.getPayload())));
        }
    }
}

