/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import com.google.inject.Module;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.guice.AetherModule;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.util.repository.JreProxySelector;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.plexus.ClassRealmManager;
import org.springframework.cloud.function.compiler.java.CompositeProxySelector;
import org.springframework.cloud.function.compiler.java.DependencyResolutionModule;
import org.springframework.cloud.function.compiler.java.MavenSettings;
import org.springframework.cloud.function.compiler.java.MavenSettingsReader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class DependencyResolver {
    private static DependencyResolver instance = new DependencyResolver();
    private static Properties globals;
    private LocalRepositoryManagerFactory localRepositoryManagerFactory;
    private PlexusContainer container;
    private final Object lock = new Object();
    private ProjectBuilder projectBuilder;
    private RepositorySystem repositorySystem;
    private MavenSettings settings;

    public static DependencyResolver instance() {
        return instance;
    }

    public static void close() {
        instance = new DependencyResolver();
    }

    private DependencyResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.container == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.container == null) {
                    DefaultPlexusContainer container;
                    ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
                    ContainerConfiguration config = new DefaultContainerConfiguration().setClassWorld(classWorld).setRealm(classWorld.getClassRealm("plexus.core")).setClassPathScanning("index").setAutoWiring(true).setName("maven");
                    try {
                        container = new DefaultPlexusContainer(config, new Module[]{new AetherModule(), new DependencyResolutionModule()});
                        this.localRepositoryManagerFactory = (LocalRepositoryManagerFactory)container.lookup(LocalRepositoryManagerFactory.class);
                        container.addComponent((Object)new ClassRealmManager((MutablePlexusContainer)container, (MutableBeanLocator)new DefaultBeanLocator()), ClassRealmManager.class.getName());
                        this.projectBuilder = (ProjectBuilder)container.lookup(ProjectBuilder.class);
                        this.repositorySystem = (RepositorySystem)container.lookup(RepositorySystem.class);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot create container", e);
                    }
                    this.container = container;
                    this.settings = new MavenSettingsReader().readSettings();
                }
            }
        }
    }

    public List<Dependency> dependencies(Resource resource) {
        return this.dependencies(resource, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dependency> dependencies(Resource resource, Properties properties) {
        this.initialize();
        try {
            ProjectBuildingRequest request = this.getProjectBuildingRequest(properties);
            request.setResolveDependencies(true);
            Class<DependencyResolver> clazz = DependencyResolver.class;
            synchronized (DependencyResolver.class) {
                ProjectBuildingResult result = this.projectBuilder.build((ModelSource)new PropertiesModelSource(properties, resource), request);
                globals = null;
                DependencyResolutionResult dependencies = result.getDependencyResolutionResult();
                if (!dependencies.getUnresolvedDependencies().isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    for (Dependency dependency : dependencies.getUnresolvedDependencies()) {
                        List errors = dependencies.getResolutionErrors(dependency);
                        for (Exception exception : errors) {
                            if (builder.length() > 0) {
                                builder.append("\n");
                            }
                            builder.append(exception.getMessage());
                        }
                    }
                    throw new RuntimeException(builder.toString());
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return this.runtime(dependencies.getDependencies());
            }
        }
        catch (ProjectBuildingException | NoLocalRepositoryManagerException e) {
            throw new IllegalStateException("Cannot build model", e);
        }
    }

    public File resolve(Dependency dependency) {
        this.initialize();
        return this.collectNonTransitive(Arrays.asList(dependency)).iterator().next().getArtifact().getFile();
    }

    private List<Dependency> runtime(List<Dependency> dependencies) {
        ArrayList<Dependency> list = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            if ("test".equals(dependency.getScope()) || "provided".equals(dependency.getScope())) continue;
            list.add(dependency);
        }
        return list;
    }

    private ProjectBuildingRequest getProjectBuildingRequest(Properties properties) throws NoLocalRepositoryManagerException {
        DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest();
        DefaultRepositorySystemSession session = this.createSession(properties);
        projectBuildingRequest.setRepositoryMerging(ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT);
        projectBuildingRequest.setRemoteRepositories(this.mavenRepositories(properties));
        projectBuildingRequest.getRemoteRepositories().addAll(this.mavenRepositories(this.settings));
        projectBuildingRequest.setRepositorySession((RepositorySystemSession)session);
        projectBuildingRequest.setProcessPlugins(false);
        projectBuildingRequest.setBuildStartTime(new Date());
        projectBuildingRequest.setUserProperties(properties);
        projectBuildingRequest.setSystemProperties(System.getProperties());
        return projectBuildingRequest;
    }

    private Collection<? extends ArtifactRepository> mavenRepositories(MavenSettings settings) {
        ArrayList<ArtifactRepository> list = new ArrayList<ArtifactRepository>();
        for (Profile profile : settings.getActiveProfiles()) {
            for (Repository repository : profile.getRepositories()) {
                this.addRepositoryIfMissing(list, repository.getId(), repository.getUrl(), repository.getReleases() != null ? repository.getReleases().isEnabled() : true, repository.getSnapshots() != null ? repository.getSnapshots().isEnabled() : false);
            }
        }
        return list;
    }

    private List<ArtifactRepository> mavenRepositories(Properties properties) {
        ArrayList<ArtifactRepository> list = new ArrayList<ArtifactRepository>();
        this.addRepositoryIfMissing(list, "spring-snapshots", "https://repo.spring.io/libs-snapshot", true, true);
        this.addRepositoryIfMissing(list, "central", "https://repo1.maven.org/maven2", true, false);
        return list;
    }

    private List<RemoteRepository> aetherRepositories(Properties properties) {
        ArrayList<RemoteRepository> list = new ArrayList<RemoteRepository>();
        for (ArtifactRepository input : this.mavenRepositories(properties)) {
            list.add(this.remote(input));
        }
        return list;
    }

    private RemoteRepository remote(ArtifactRepository input) {
        return new RemoteRepository.Builder(input.getId(), input.getLayout().getId(), input.getUrl()).setSnapshotPolicy(this.policy(input.getSnapshots())).setReleasePolicy(this.policy(input.getReleases())).build();
    }

    private RepositoryPolicy policy(ArtifactRepositoryPolicy input) {
        RepositoryPolicy policy = new RepositoryPolicy(input.isEnabled(), "daily", "warn");
        return policy;
    }

    private void addRepositoryIfMissing(List<ArtifactRepository> list, String id, String url, boolean releases, boolean snapshots) {
        for (ArtifactRepository repo : list) {
            if (url.equals(repo.getUrl())) {
                return;
            }
            if (!id.equals(repo.getId())) continue;
            return;
        }
        list.add(this.repo(id, url, releases, snapshots));
    }

    private ArtifactRepository repo(String id, String url, boolean releases, boolean snapshots) {
        MavenArtifactRepository repository = new MavenArtifactRepository();
        repository.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
        repository.setId(id);
        repository.setUrl(url);
        ArtifactRepositoryPolicy enabled = new ArtifactRepositoryPolicy();
        enabled.setEnabled(true);
        ArtifactRepositoryPolicy disabled = new ArtifactRepositoryPolicy();
        disabled.setEnabled(false);
        repository.setReleaseUpdatePolicy(releases ? enabled : disabled);
        repository.setSnapshotUpdatePolicy(snapshots ? enabled : disabled);
        return repository;
    }

    private DefaultRepositorySystemSession createSession(Properties properties) throws NoLocalRepositoryManagerException {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository repository = this.localRepository(properties);
        session.setLocalRepositoryManager(this.localRepositoryManagerFactory.newInstance((RepositorySystemSession)session, repository));
        this.applySettings(session);
        ProxySelector existing = session.getProxySelector();
        if (existing == null || !(existing instanceof CompositeProxySelector)) {
            JreProxySelector fallback = new JreProxySelector();
            Object selector = existing == null ? fallback : new CompositeProxySelector(Arrays.asList(existing, fallback));
            session.setProxySelector((ProxySelector)selector);
        }
        return session;
    }

    private void applySettings(DefaultRepositorySystemSession session) {
        MavenSettingsReader.applySettings(this.settings, session);
    }

    private LocalRepository localRepository(Properties properties) {
        return new LocalRepository(this.getM2RepoDirectory());
    }

    public Model readModel(Resource resource) {
        return this.readModel(resource, new Properties());
    }

    public Model readModel(Resource resource, Properties properties) {
        this.initialize();
        try {
            ProjectBuildingRequest request = this.getProjectBuildingRequest(properties);
            request.setResolveDependencies(false);
            ProjectBuildingResult result = this.projectBuilder.build((ModelSource)new PropertiesModelSource(properties, resource), request);
            return result.getProject().getModel();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to build model from effective pom", e);
        }
    }

    private File getM2RepoDirectory() {
        return new File(this.getDefaultM2HomeDirectory(), "repository");
    }

    private File getDefaultM2HomeDirectory() {
        String mavenRoot = System.getProperty("maven.home");
        if (StringUtils.hasLength((String)mavenRoot)) {
            return new File(mavenRoot);
        }
        return new File(System.getProperty("user.home"), ".m2");
    }

    private List<ArtifactResult> collectNonTransitive(List<Dependency> dependencies) {
        try {
            List<ArtifactRequest> artifactRequests = this.getArtifactRequests(dependencies);
            List result = this.repositorySystem.resolveArtifacts((RepositorySystemSession)this.createSession(new Properties()), artifactRequests);
            return result;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private List<ArtifactRequest> getArtifactRequests(List<Dependency> dependencies) {
        ArrayList<ArtifactRequest> list = new ArrayList<ArtifactRequest>();
        for (Dependency dependency : dependencies) {
            ArtifactRequest request = new ArtifactRequest(dependency.getArtifact(), null, null);
            request.setRepositories(this.aetherRepositories(new Properties()));
            list.add(request);
        }
        return list;
    }

    static Properties getGlobals() {
        return globals;
    }

    private static final class PropertiesModelSource
    implements ModelSource {
        private final Properties properties;
        private final Resource resource;

        private PropertiesModelSource(Properties properties, Resource resource) {
            this.properties = properties;
            this.resource = resource;
        }

        public InputStream getInputStream() throws IOException {
            globals = this.properties;
            return new BufferedInputStream(this.resource.getInputStream()){

                @Override
                public void close() throws IOException {
                    globals = null;
                    super.close();
                }
            };
        }

        public String getLocation() {
            return this.resource.getDescription();
        }
    }
}

