/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.springframework.cloud.function.compiler.java.JrtEntryJavaFileObject;

public class JrtFsEnumeration
implements Enumeration<JrtEntryJavaFileObject> {
    private static URI JRT_URI = URI.create("jrt:/");
    private static final FileSystem fs = FileSystems.getFileSystem(JRT_URI);
    private Path pathWithinJrt;
    private List<JrtEntryJavaFileObject> jfos = new ArrayList<JrtEntryJavaFileObject>();
    private Integer counter = 0;
    private Boolean initialized = false;

    public JrtFsEnumeration(File jrtFsFile, Path pathWithinJrt) {
        this.pathWithinJrt = pathWithinJrt;
        this.ensureInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        Boolean bl = this.initialized;
        synchronized (bl) {
            if (this.initialized.booleanValue()) {
                return;
            }
            FileCacheBuilderVisitor visitor = new FileCacheBuilderVisitor();
            if (this.pathWithinJrt != null) {
                try {
                    Files.walkFileTree(this.pathWithinJrt, visitor);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            Iterable<Path> roots = fs.getRootDirectories();
            try {
                for (Path path : roots) {
                    Files.walkFileTree(path, visitor);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.initialized = true;
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.counter < this.jfos.size();
    }

    @Override
    public JrtEntryJavaFileObject nextElement() {
        if (this.counter >= this.jfos.size()) {
            throw new NoSuchElementException();
        }
        Integer n = this.counter;
        Integer n2 = this.counter = Integer.valueOf(this.counter + 1);
        JrtEntryJavaFileObject toReturn = this.jfos.get(n);
        return toReturn;
    }

    public String getName(JrtEntryJavaFileObject file) {
        return file.getPathToClassString();
    }

    public void reset() {
        this.counter = 0;
    }

    class FileCacheBuilderVisitor
    extends SimpleFileVisitor<Path> {
        FileCacheBuilderVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            int fnc = file.getNameCount();
            if (fnc >= 3 && file.toString().endsWith(".class")) {
                JrtFsEnumeration.this.jfos.add(new JrtEntryJavaFileObject(file));
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

