/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.cloud.function.compiler.CompilationResultFactory;
import org.springframework.cloud.function.compiler.java.CompilationResult;
import org.springframework.util.ReflectionUtils;

public class CompiledFunctionFactory<T>
implements CompilationResultFactory<T> {
    private final T result;
    private final byte[] generatedClassBytes;
    private String inputType;
    private String outputType;
    private Method method;

    public CompiledFunctionFactory(String className, CompilationResult compilationResult) {
        List<Class<?>> clazzes = compilationResult.getCompiledClasses();
        Object result = null;
        Method method = null;
        for (Class<?> clazz : clazzes) {
            if (!clazz.getName().equals(className)) continue;
            try {
                CompilationResultFactory factory = (CompilationResultFactory)clazz.newInstance();
                result = factory.getResult();
                method = this.findFactoryMethod(clazz);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unexpected problem during retrieval of Function from compiled class", e);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to extract compilation result.");
        }
        this.result = result;
        this.method = method;
        this.generatedClassBytes = compilationResult.getClassBytes(className);
    }

    private Method findFactoryMethod(Class<?> clazz) {
        AtomicReference method = new AtomicReference();
        ReflectionUtils.doWithLocalMethods(clazz, m -> {
            if (m.getName().equals("getResult") && m.getReturnType().getName().startsWith("java.util.function")) {
                method.set(m);
            }
        });
        return (Method)method.get();
    }

    @Override
    public T getResult() {
        return this.result;
    }

    public Method getFactoryMethod() {
        return this.method;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public byte[] getGeneratedClassBytes() {
        return this.generatedClassBytes;
    }
}

