/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

public class DirEntryJavaFileObject
implements JavaFileObject {
    private File file;
    private File basedir;

    public DirEntryJavaFileObject(File basedir, File file) {
        this.basedir = basedir;
        this.file = file;
    }

    @Override
    public URI toUri() {
        return this.file.toURI();
    }

    @Override
    public String getName() {
        String basedirPath = this.basedir.getPath();
        String filePath = this.file.getPath();
        return filePath.substring(basedirPath.length() + 1);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new IllegalStateException("Only expected to be used for input");
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException("openReader() not supported on class file: " + this.getName());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException("getCharContent() not supported on class file: " + this.getName());
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new IllegalStateException("only expected to be used for input");
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.CLASS;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        if (kind != JavaFileObject.Kind.CLASS) {
            return false;
        }
        String name = this.getName();
        int lastSlash = name.lastIndexOf(47);
        return name.substring(lastSlash + 1).equals(simpleName + ".class");
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    public int hashCode() {
        return this.file.getName().hashCode() * 37 + this.basedir.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DirEntryJavaFileObject)) {
            return false;
        }
        DirEntryJavaFileObject that = (DirEntryJavaFileObject)obj;
        return this.basedir.getName().equals(that.basedir.getName()) && this.file.getName().equals(that.file.getName());
    }
}

