/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

public class NestedZipEntryJavaFileObject
implements JavaFileObject {
    private File outerFile;
    private ZipFile outerZipFile;
    private ZipEntry innerZipFile;
    private ZipEntry innerZipFileEntry;
    private URI uri;

    public NestedZipEntryJavaFileObject(File outerFile, ZipFile outerZipFile, ZipEntry innerZipFile, ZipEntry innerZipFileEntry) {
        this.outerFile = outerFile;
        this.outerZipFile = outerZipFile;
        this.innerZipFile = innerZipFile;
        this.innerZipFileEntry = innerZipFileEntry;
    }

    @Override
    public String getName() {
        return this.innerZipFileEntry.getName();
    }

    @Override
    public URI toUri() {
        if (this.uri == null) {
            String uriString = null;
            try {
                uriString = "zip:" + this.outerFile.getAbsolutePath() + "!" + this.innerZipFile.getName() + "!" + this.innerZipFileEntry.getName();
                this.uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Unexpected URISyntaxException for string '" + uriString + "'", e);
            }
        }
        return this.uri;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        InputStream innerZipFileInputStream = this.outerZipFile.getInputStream(this.innerZipFile);
        ZipInputStream innerZipInputStream = new ZipInputStream(innerZipFileInputStream);
        ZipEntry nextEntry = innerZipInputStream.getNextEntry();
        while (nextEntry != null) {
            if (nextEntry.getName().equals(this.innerZipFileEntry.getName())) {
                return innerZipInputStream;
            }
            nextEntry = innerZipInputStream.getNextEntry();
        }
        throw new IllegalStateException("Unable to locate nested zip entry " + this.innerZipFileEntry.getName() + " in zip " + this.innerZipFile.getName() + " inside zip " + this.outerZipFile.getName());
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException("getCharContent() not supported on class file: " + this.getName());
    }

    @Override
    public long getLastModified() {
        return this.innerZipFileEntry.getTime();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.CLASS;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new IllegalStateException("cannot write to nested zip entry: " + this.toUri());
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new IllegalStateException("cannot write to nested zip entry: " + this.toUri());
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        if (kind != JavaFileObject.Kind.CLASS) {
            return false;
        }
        String name = this.getName();
        int lastSlash = name.lastIndexOf(47);
        return name.substring(lastSlash + 1).equals(simpleName + ".class");
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException("getCharContent() not supported on class file: " + this.getName());
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    public int hashCode() {
        int hc = this.outerFile.getName().hashCode();
        hc = hc * 37 + this.innerZipFile.getName().hashCode();
        hc = hc * 37 + this.innerZipFileEntry.getName().hashCode();
        return hc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NestedZipEntryJavaFileObject)) {
            return false;
        }
        NestedZipEntryJavaFileObject that = (NestedZipEntryJavaFileObject)obj;
        return this.outerFile.getName().equals(that.outerFile.getName()) && this.innerZipFile.getName().equals(that.innerZipFile.getName()) && this.innerZipFileEntry.getName().equals(that.innerZipFileEntry.getName());
    }
}

