/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.function.compiler.java.CompilationMessage;
import org.springframework.cloud.function.compiler.java.CompilationResult;
import org.springframework.cloud.function.compiler.java.CompiledClassDefinition;
import org.springframework.cloud.function.compiler.java.InMemoryJavaFileObject;
import org.springframework.cloud.function.compiler.java.MemoryBasedJavaFileManager;
import org.springframework.cloud.function.compiler.java.SimpleClassLoader;

public class RuntimeJavaCompiler {
    private static Logger logger = LoggerFactory.getLogger(RuntimeJavaCompiler.class);
    private JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    public CompilationResult compile(String className, String classSourceCode, String ... dependencies) {
        logger.info("Compiling source for class {} using compiler {}", (Object)className, (Object)this.compiler.getClass().getName());
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        MemoryBasedJavaFileManager fileManager = new MemoryBasedJavaFileManager();
        List<CompilationMessage> resolutionMessages = fileManager.addAndResolveDependencies(dependencies);
        InMemoryJavaFileObject sourceFile = InMemoryJavaFileObject.getSourceJavaFileObject(className, classSourceCode);
        List<JavaFileObject> compilationUnits = Arrays.asList(sourceFile);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-source");
        options.add("1.8");
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, fileManager, diagnosticCollector, options, null, compilationUnits);
        boolean success = task.call();
        CompilationResult compilationResult = new CompilationResult(success);
        compilationResult.recordCompilationMessages(resolutionMessages);
        compilationResult.setResolvedAdditionalDependencies(new ArrayList<File>(fileManager.getResolvedAdditionalDependencies().values()));
        for (Diagnostic diagnostic : diagnosticCollector.getDiagnostics()) {
            CompilationMessage.Kind kind = diagnostic.getKind() == Diagnostic.Kind.ERROR ? CompilationMessage.Kind.ERROR : CompilationMessage.Kind.OTHER;
            String sourceCode = null;
            try {
                sourceCode = (String)((JavaFileObject)diagnostic.getSource()).getCharContent(true);
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            int startPosition = (int)diagnostic.getPosition();
            if ((long)startPosition == -1L) {
                startPosition = (int)diagnostic.getStartPosition();
            }
            CompilationMessage compilationMessage = new CompilationMessage(kind, diagnostic.getMessage(null), sourceCode, startPosition, (int)diagnostic.getEndPosition());
            compilationResult.recordCompilationMessage(compilationMessage);
        }
        if (success) {
            List<CompiledClassDefinition> ccds = fileManager.getCompiledClasses();
            ArrayList classes = new ArrayList();
            try (SimpleClassLoader ccl = new SimpleClassLoader(this.getClass().getClassLoader());){
                for (CompiledClassDefinition ccd : ccds) {
                    Class<?> clazz = ccl.defineClass(ccd.getClassName(), ccd.getBytes());
                    classes.add(clazz);
                    compilationResult.addClassBytes(ccd.getClassName(), ccd.getBytes());
                }
            }
            catch (IOException ioe) {
                logger.debug("Unexpected exception defining classes", (Throwable)ioe);
            }
            compilationResult.setCompiledClasses(classes);
        }
        return compilationResult;
    }
}

