/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.proxy;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.asm.ClassReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.function.compiler.CompilationResultFactory;
import org.springframework.cloud.function.compiler.java.SimpleClassLoader;
import org.springframework.cloud.function.core.FunctionFactoryMetadata;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ReflectionUtils;

abstract class AbstractByteCodeLoadingProxy<T>
implements InitializingBean,
FunctionFactoryMetadata<T> {
    private final Resource resource;
    private final SimpleClassLoader classLoader = new SimpleClassLoader(AbstractByteCodeLoadingProxy.class.getClassLoader());
    private T target;
    private Method method;

    AbstractByteCodeLoadingProxy(Resource resource) {
        this.resource = resource;
    }

    public void afterPropertiesSet() throws Exception {
        byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)this.resource.getInputStream());
        String className = new ClassReader(bytes).getClassName().replace("/", ".");
        Class<?> factoryClass = this.classLoader.defineClass(className, bytes);
        try {
            this.target = ((CompilationResultFactory)factoryClass.newInstance()).getResult();
            this.method = this.findFactoryMethod(factoryClass);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("failed to load Function byte code", e);
        }
    }

    public final T getTarget() {
        return this.target;
    }

    public Method getFactoryMethod() {
        return this.method;
    }

    private Method findFactoryMethod(Class<?> clazz) {
        AtomicReference method = new AtomicReference();
        ReflectionUtils.doWithLocalMethods(clazz, m -> {
            if (m.getName().equals("getResult") && m.getReturnType().getName().startsWith("java.util.function")) {
                method.set(m);
            }
        });
        return (Method)method.get();
    }
}

