/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.proxy;

import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.function.compiler.AbstractFunctionCompiler;
import org.springframework.cloud.function.compiler.CompiledFunctionFactory;
import org.springframework.cloud.function.core.FunctionFactoryMetadata;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class AbstractLambdaCompilingProxy<T>
implements InitializingBean,
BeanNameAware,
FunctionFactoryMetadata<T> {
    private final Resource resource;
    private final AbstractFunctionCompiler<T> compiler;
    private String beanName;
    private CompiledFunctionFactory<T> factory;
    private String[] typeParameterizations;

    public AbstractLambdaCompilingProxy(Resource resource, AbstractFunctionCompiler<T> compiler) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        Assert.notNull(compiler, (String)"Compiler must not be null");
        this.resource = resource;
        this.compiler = compiler;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setTypeParameterizations(String ... typeParameterizations) {
        this.typeParameterizations = typeParameterizations;
    }

    public void afterPropertiesSet() throws Exception {
        String lambda = FileCopyUtils.copyToString((Reader)new InputStreamReader(this.resource.getInputStream()));
        this.factory = this.compiler.compile(this.beanName, lambda, this.typeParameterizations);
    }

    public final T getTarget() {
        return this.factory.getResult();
    }

    public Method getFactoryMethod() {
        return this.factory.getFactoryMethod();
    }
}

