/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.function.json.JsonMapper;

public class JacksonMapper
implements JsonMapper {
    private final ObjectMapper mapper;

    public JacksonMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <T> List<T> toList(String json, Class<T> type) {
        try {
            return (List)this.mapper.readValue(json, (JavaType)this.mapper.getTypeFactory().constructCollectionLikeType(ArrayList.class, type));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert JSON", e);
        }
    }

    @Override
    public <T> T toSingle(String json, Class<T> type) {
        try {
            return (T)this.mapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert JSON", e);
        }
    }

    @Override
    public String toString(Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot convert to JSON", e);
        }
    }
}

