/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.catalog.FunctionRegistrationEvent;
import org.springframework.cloud.function.context.catalog.FunctionUnregistrationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.Assert;

public class InMemoryFunctionCatalog
implements FunctionRegistry,
FunctionInspector,
ApplicationEventPublisherAware {
    private final Map<Class<?>, Map<String, Object>> functions;
    private final Map<Object, FunctionRegistration<?>> registrations;
    private ApplicationEventPublisher publisher;

    public InMemoryFunctionCatalog() {
        this(Collections.emptySet());
    }

    public InMemoryFunctionCatalog(Set<FunctionRegistration<?>> registrations) {
        Assert.notNull(registrations, (String)"'registrations' must not be null");
        this.functions = new HashMap();
        this.registrations = new HashMap();
        registrations.stream().forEach(reg -> this.register((FunctionRegistration)reg));
    }

    @Override
    public FunctionRegistration<?> getRegistration(Object function) {
        return this.registrations.get(function);
    }

    @Override
    public <T> void register(FunctionRegistration<T> registration) {
        Assert.notEmpty(registration.getNames(), (String)"'registration' must contain at least one name before it is registered in catalog.");
        Class<Object> type = Object.class;
        if (registration.getTarget() instanceof Function) {
            type = Function.class;
        } else if (registration.getTarget() instanceof Supplier) {
            type = Supplier.class;
        } else if (registration.getTarget() instanceof Consumer) {
            type = Consumer.class;
        }
        FunctionRegistrationEvent event = new FunctionRegistrationEvent(this, type, registration.getNames());
        this.registrations.put(registration.getTarget(), registration);
        FunctionRegistration wrapped = registration.wrap();
        if (wrapped != registration) {
            registration = wrapped;
            this.registrations.put(wrapped.getTarget(), wrapped);
            if (type == Consumer.class) {
                type = Function.class;
            }
        }
        Map map = this.functions.computeIfAbsent(type, key -> new HashMap());
        for (String name : registration.getNames()) {
            map.put(name, registration.getTarget());
        }
        this.publishEvent((Object)event);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @PostConstruct
    public void init() {
        if (this.publisher != null && !this.functions.isEmpty()) {
            this.functions.keySet().forEach(type -> this.publishEvent((Object)new FunctionRegistrationEvent(this, (Class<?>)type, this.functions.get(type).keySet())));
        }
    }

    @PreDestroy
    public void close() {
        if (this.publisher != null && !this.functions.isEmpty()) {
            this.functions.keySet().forEach(type -> this.publishEvent((Object)new FunctionUnregistrationEvent(this, (Class<?>)type, this.functions.get(type).keySet())));
        }
    }

    @Override
    public <T> T lookup(Class<?> type, String name) {
        Object function = null;
        function = type == null ? this.functions.values().stream().filter(map -> map.get(name) != null).map(map -> map.get(name)).findFirst().orElse(null) : this.extractTypeMap(type).get(name);
        return (T)function;
    }

    @Override
    public Set<String> getNames(Class<?> type) {
        Map<String, Object> map = this.extractTypeMap(type);
        return map == null ? Collections.emptySet() : map.keySet();
    }

    private Map<String, Object> extractTypeMap(Class<?> type) {
        return this.functions.keySet().stream().filter(key -> key != Object.class && key.isAssignableFrom(type)).map(key -> this.functions.get(key)).findFirst().orElse(this.functions.get(Object.class));
    }

    private void publishEvent(Object event) {
        if (this.publisher != null) {
            this.publisher.publishEvent(event);
        }
    }
}

