/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.BeanFactoryAwareFunctionRegistry;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.context.config.JsonMessageConverter;
import org.springframework.cloud.function.context.config.RoutingFunction;
import org.springframework.cloud.function.json.GsonMapper;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={FunctionCatalog.class})
@EnableConfigurationProperties(value={FunctionProperties.class})
public class ContextFunctionCatalogAutoConfiguration {
    static final String PREFERRED_MAPPER_PROPERTY = "spring.http.converters.preferred-json-mapper";

    @Bean
    public FunctionRegistry functionCatalog(List<MessageConverter> messageConverters, JsonMapper jsonMapper, ConfigurableApplicationContext context) {
        ConfigurableConversionService conversionService = (ConfigurableConversionService)context.getBeanFactory().getConversionService();
        Map converters = context.getBeansOfType(GenericConverter.class);
        for (GenericConverter converter : converters.values()) {
            conversionService.addConverter(converter);
        }
        CompositeMessageConverter messageConverter = null;
        List<Object> mcList = new ArrayList();
        if (!CollectionUtils.isEmpty(messageConverters)) {
            for (MessageConverter mc : messageConverters) {
                if (mc instanceof CompositeMessageConverter) {
                    mcList.addAll(((CompositeMessageConverter)mc).getConverters());
                    continue;
                }
                mcList.add(mc);
            }
        }
        mcList = mcList.stream().filter(c -> this.isConverterEligible(c)).collect(Collectors.toList());
        mcList.add((Object)new JsonMessageConverter(jsonMapper));
        mcList.add(new ByteArrayMessageConverter());
        mcList.add(new StringMessageConverter());
        if (!CollectionUtils.isEmpty(mcList)) {
            messageConverter = new CompositeMessageConverter(mcList);
        }
        return new BeanFactoryAwareFunctionRegistry((ConversionService)conversionService, messageConverter);
    }

    @Bean(value={"functionRouter"})
    RoutingFunction functionRouter(FunctionCatalog functionCatalog, FunctionInspector functionInspector, FunctionProperties functionProperties) {
        return new RoutingFunction(functionCatalog, functionInspector, functionProperties);
    }

    private boolean isConverterEligible(Object messageConverter) {
        String messageConverterName = messageConverter.getClass().getName();
        if (messageConverterName.startsWith("org.springframework.cloud.")) {
            return true;
        }
        return !messageConverterName.startsWith("org.springframework.");
    }

    @Configuration(proxyBeanMethods=false)
    public static class JsonMapperConfiguration {
        @Bean
        public JsonMapper jsonMapper(ApplicationContext context) {
            String preferredMapper = context.getEnvironment().getProperty(ContextFunctionCatalogAutoConfiguration.PREFERRED_MAPPER_PROPERTY);
            if (StringUtils.hasText((String)preferredMapper)) {
                if ("gson".equals(preferredMapper) && ClassUtils.isPresent((String)"com.google.gson.Gson", null)) {
                    return this.gson(context);
                }
                if ("jackson".equals(preferredMapper) && ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", null)) {
                    return this.jackson(context);
                }
            } else {
                if (ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", null)) {
                    return this.jackson(context);
                }
                if (ClassUtils.isPresent((String)"com.google.gson.Gson", null)) {
                    return this.gson(context);
                }
            }
            throw new IllegalStateException("Failed to configure JsonMapper. Neither jackson nor gson are present on the claspath");
        }

        private JsonMapper gson(ApplicationContext context) {
            Gson gson;
            try {
                gson = (Gson)context.getBean(Gson.class);
            }
            catch (Exception e) {
                gson = new Gson();
            }
            return new GsonMapper(gson);
        }

        private JsonMapper jackson(ApplicationContext context) {
            ObjectMapper mapper;
            try {
                mapper = (ObjectMapper)context.getBean(ObjectMapper.class);
            }
            catch (Exception e) {
                mapper = new ObjectMapper();
            }
            return new JacksonMapper(mapper);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ComponentScan(basePackages={"${spring.cloud.function.scan.packages:functions}"}, includeFilters={@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, classes={Supplier.class, Function.class, Consumer.class})})
    @ConditionalOnProperty(prefix="spring.cloud.function.scan", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class PlainFunctionScanConfiguration {
        protected PlainFunctionScanConfiguration() {
        }
    }
}

