/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;

public final class NegotiatingMessageConverterWrapper
implements SmartMessageConverter {
    public static final String ACCEPT = "accept";
    private final AbstractMessageConverter delegate;

    private NegotiatingMessageConverterWrapper(AbstractMessageConverter delegate) {
        this.delegate = delegate;
    }

    public static NegotiatingMessageConverterWrapper wrap(AbstractMessageConverter delegate) {
        return new NegotiatingMessageConverterWrapper(delegate);
    }

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        return this.fromMessage(message, targetClass, null);
    }

    private boolean isJsonContentType(Message<?> message) {
        Object ct = message.getHeaders().get((Object)"contentType");
        if (ct != null) {
            ct = ct.toString();
            return ((String)ct).startsWith("application/json");
        }
        return false;
    }

    public Object fromMessage(final Message<?> message, Class<?> targetClass, Object conversionHint) {
        if (!this.isJsonContentType(message) && message.getPayload() instanceof Collection) {
            Collection collection = ((Collection)message.getPayload()).stream().map(value -> {
                try {
                    Message<Object> m = new Message<Object>(){

                        public Object getPayload() {
                            return value;
                        }

                        public MessageHeaders getHeaders() {
                            return message.getHeaders();
                        }
                    };
                    if (conversionHint != null && conversionHint instanceof ParameterizedType) {
                        Type tClass = FunctionTypeUtils.getImmediateGenericType((ParameterizedType)conversionHint, 0);
                        if (byte[].class.isAssignableFrom((Class)tClass)) {
                            return message;
                        }
                        return this.delegate.fromMessage((Message)m, (Class)tClass);
                    }
                    return this.delegate.fromMessage((Message)m, targetClass, conversionHint);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(v -> v != null).collect(Collectors.toList());
            return CollectionUtils.isEmpty((Collection)collection) ? null : collection;
        }
        return this.delegate.fromMessage(message, targetClass, conversionHint);
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers, Object conversionHint) {
        MimeType accepted = (MimeType)headers.get((Object)ACCEPT, MimeType.class);
        MessageHeaderAccessor accessor = new MessageHeaderAccessor();
        accessor.copyHeaders((Map)headers);
        accessor.removeHeader(ACCEPT);
        if (accepted == null) {
            accepted = (MimeType)headers.get((Object)"contentType", MimeType.class);
        }
        if (accepted != null) {
            for (MimeType supportedConcreteType : this.delegate.getSupportedMimeTypes()) {
                if (!accepted.includes(supportedConcreteType)) continue;
                accessor.setHeader("contentType", (Object)supportedConcreteType);
                Message result = this.delegate.toMessage(payload, accessor.toMessageHeaders(), conversionHint);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        return this.toMessage(payload, headers, null);
    }
}

